/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.ri.runtime;

import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.InputSet;
import org.jboss.bpm.model.OutputSet;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.bpm.ri.runtime.DelegatingExecutionContext;
import org.jboss.bpm.ri.runtime.MutableToken;
import org.jboss.bpm.runtime.ExecutionContext;
import org.jboss.bpm.runtime.Token;

public class DelegatingToken
implements MutableToken {
    private MutableToken delegateToken;
    private ExecutionContext delegateContext;

    public DelegatingToken(MutableToken token) {
        this.delegateToken = token;
        FlowObject targetRef = token.getFlow().getTargetRef();
        ExecutionContext exContext = token.getExecutionContext();
        this.delegateContext = new DelegatingExecutionContext(targetRef, exContext);
    }

    public ExecutionContext getExecutionContext() {
        return this.delegateContext;
    }

    public Token copyToken() {
        return this.delegateToken.copyToken();
    }

    public SequenceFlow getFlow() {
        return this.delegateToken.getFlow();
    }

    public InputSet getInputSet() {
        return this.delegateToken.getInputSet();
    }

    public OutputSet getOutputSet() {
        return this.delegateToken.getOutputSet();
    }

    public String getTokenID() {
        return this.delegateToken.getTokenID();
    }

    public Token.TokenStatus getTokenStatus() {
        return this.delegateToken.getTokenStatus();
    }

    public void mergeToken(Token token) {
        this.delegateToken.mergeToken(token);
    }

    public void setFlow(SequenceFlow flow) {
        this.delegateToken.setFlow(flow);
    }

    public void setTokenStatus(Token.TokenStatus status) {
        this.delegateToken.setTokenStatus(status);
    }

    public void setInputSet(InputSet inputSet) {
        this.delegateToken.setInputSet(inputSet);
    }

    public void setOutputSet(OutputSet outputSet) {
        this.delegateToken.setOutputSet(outputSet);
    }

    public String toString() {
        FlowObject fo = this.getFlow().getTargetRef();
        return "[fo=" + fo + ",ctx=" + this.getExecutionContext() + "]";
    }
}

