package org.jboss.bpm.samples.airticket.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Application implements EntryPoint
{
  private AirticketServiceAsync sampleRemoteService;

  private Label labelMessage = new Label();

  private Label labelName = new Label("Name:");
  private Label labelFrom = new Label("From:");
  private Label labelTo = new Label("To:");
  private Label labelDate = new Label("Date:");
  private Label labelSeats = new Label("Seats:");
  private Label labelPrice = new Label("Price:");
  private Label labelCreditCard = new Label("CreditCard:");
  private Label labelExpire = new Label("Expire:");
  private Label labelAccept = new Label("Accept:");

  private Label labelNameRO = new Label();
  private Label labelFromRO = new Label();
  private Label labelToRO = new Label();
  private Label labelDateRO = new Label();
  private Label labelSeatsRO = new Label();
  private Label labelPriceRO = new Label();

  private TextBox textName = new TextBox();
  private TextBox textFrom = new TextBox();
  private TextBox textTo = new TextBox();
  private TextBox textDate = new TextBox();
  private TextBox textSeats = new TextBox();
  private TextBox textCreditCard = new TextBox();
  private TextBox textExpire = new TextBox();
  private CheckBox checkAccept = new CheckBox();

  private Button buttonSubmitRequest = new Button("Submit");
  private Button buttonSubmitOrder = new Button("Submit");
  private Button buttonSubmitConfirm = new Button("Submit");

  /**
   * This is the entry point method.
   */
  public void onModuleLoad()
  {
    // image bundle
    SampleImageBundle sampleImageBundle = (SampleImageBundle)GWT.create(SampleImageBundle.class);
    Image logoImage = sampleImageBundle.getGWTLogo().createImage();
    RootPanel.get("gwtLogo").add(logoImage);

    sampleRemoteService = (AirticketServiceAsync)GWT.create(AirticketService.class);
    ServiceDefTarget endpoint = (ServiceDefTarget)sampleRemoteService;
    String moduleRelativeURL = GWT.getModuleBaseURL() + "airticketService";
    endpoint.setServiceEntryPoint(moduleRelativeURL);

    buttonSubmitRequest.addClickListener(new MyClickListener());
    buttonSubmitOrder.addClickListener(new MyClickListener());
    buttonSubmitConfirm.addClickListener(new MyClickListener());

    Panel panel = getRequestPanel();
    RootPanel.get("gwtPanel").add(panel);
    RootPanel.get("gwtMessage").add(labelMessage);
    
    initRequestPanel(getDefaultData());
  }

  private GwtMessage getDefaultData()
  {
    GwtMessage gwtMsg = new GwtMessage();
    gwtMsg.name = "Kermit";
    gwtMsg.from = "MUC";
    gwtMsg.to = "NYC";
    gwtMsg.date = "30-Oct-2008";
    gwtMsg.seats = new Integer(2);
    return gwtMsg;
  }

  private Panel getRequestPanel()
  {
    DockPanel panel = new DockPanel();
    Grid grid = new Grid(5, 2);
    grid.setWidget(0, 0, labelName);
    grid.setWidget(0, 1, textName);
    grid.setWidget(1, 0, labelFrom);
    grid.setWidget(1, 1, textFrom);
    grid.setWidget(2, 0, labelTo);
    grid.setWidget(2, 1, textTo);
    grid.setWidget(3, 0, labelDate);
    grid.setWidget(3, 1, textDate);
    grid.setWidget(4, 0, labelSeats);
    grid.setWidget(4, 1, textSeats);
    panel.add(grid, DockPanel.CENTER);
    panel.add(buttonSubmitRequest, DockPanel.SOUTH);
    return panel;
  }

  private void initRequestPanel(GwtMessage gwtMsg)
  {
    textName.setText(gwtMsg.name);
    textFrom.setText(gwtMsg.from);
    textTo.setText(gwtMsg.to);
    textDate.setText(gwtMsg.date);
    textSeats.setText(gwtMsg.seats != null ? gwtMsg.seats.toString() : "0");
  }
  
  private Panel getOfferPanel()
  {
    DockPanel panel = new DockPanel();
    Grid grid = new Grid(9, 2);
    grid.setWidget(0, 0, labelName);
    grid.setWidget(0, 1, labelNameRO);
    grid.setWidget(1, 0, labelFrom);
    grid.setWidget(1, 1, labelFromRO);
    grid.setWidget(2, 0, labelTo);
    grid.setWidget(2, 1, labelToRO);
    grid.setWidget(3, 0, labelDate);
    grid.setWidget(3, 1, labelDateRO);
    grid.setWidget(4, 0, labelSeats);
    grid.setWidget(4, 1, labelSeatsRO);
    grid.setWidget(5, 0, labelPrice);
    grid.setWidget(5, 1, labelPriceRO);
    grid.setWidget(6, 0, labelCreditCard);
    grid.setWidget(6, 1, textCreditCard);
    grid.setWidget(7, 0, labelExpire);
    grid.setWidget(7, 1, textExpire);
    grid.setWidget(8, 0, labelAccept);
    grid.setWidget(8, 1, checkAccept);
    panel.add(grid, DockPanel.CENTER);
    panel.add(buttonSubmitOrder, DockPanel.SOUTH);
    return panel;
  }

  private void initOfferPanel(OfferMessage gwtMsg)
  {
    labelNameRO.setText(gwtMsg.name);
    labelFromRO.setText(gwtMsg.from);
    labelToRO.setText(gwtMsg.to);
    labelDateRO.setText(gwtMsg.date);
    labelSeatsRO.setText(gwtMsg.seats != null ? gwtMsg.seats.toString() : "0");
    labelPriceRO.setText(gwtMsg.price != null ? gwtMsg.price.toString() : "0");
    
    textCreditCard.setText("1234-1234-1234-1234");
    textExpire.setText("30-Jul-2012");
    checkAccept.setChecked(true);
  }

  private Panel getConfirmPanel()
  {
    DockPanel panel = new DockPanel();
    Grid grid = new Grid(6, 2);
    grid.setWidget(0, 0, labelName);
    grid.setWidget(0, 1, labelNameRO);
    grid.setWidget(1, 0, labelFrom);
    grid.setWidget(1, 1, labelFromRO);
    grid.setWidget(2, 0, labelTo);
    grid.setWidget(2, 1, labelToRO);
    grid.setWidget(3, 0, labelDate);
    grid.setWidget(3, 1, labelDateRO);
    grid.setWidget(4, 0, labelSeats);
    grid.setWidget(4, 1, labelSeatsRO);
    grid.setWidget(5, 0, labelPrice);
    grid.setWidget(5, 1, labelPriceRO);
    panel.add(grid, DockPanel.CENTER);
    panel.add(buttonSubmitConfirm, DockPanel.SOUTH);
    return panel;
  }

  private void initConfirmPanel(ConfirmMessage gwtMsg)
  {
    labelNameRO.setText(gwtMsg.name);
    labelFromRO.setText(gwtMsg.from);
    labelToRO.setText(gwtMsg.to);
    labelDateRO.setText(gwtMsg.date);
    labelSeatsRO.setText(gwtMsg.seats != null ? gwtMsg.seats.toString() : "0");
    labelPriceRO.setText(gwtMsg.price != null ? gwtMsg.price.toString() : "0");
  }
  
  private void setVisiblePanel(Panel panel)
  {
    RootPanel.get("gwtPanel").remove(0);
    RootPanel.get("gwtPanel").add(panel);
  }

  class MyClickListener implements ClickListener
  {
    public void onClick(Widget sender)
    {
      if (sender == buttonSubmitRequest)
      {
        RequestMessage gwtMsg = new RequestMessage();
        gwtMsg.name = textName.getText();
        gwtMsg.from = textFrom.getText();
        gwtMsg.to = textTo.getText();
        gwtMsg.date = textDate.getText();
        gwtMsg.seats = new Integer(textSeats.getText());
        sendGwtMessage(gwtMsg);
      }
      if (sender == buttonSubmitOrder)
      {
        OrderMessage gwtMsg = new OrderMessage();
        gwtMsg.creditCard = textCreditCard.getText();
        gwtMsg.expire = textExpire.getText();
        gwtMsg.acceptOffer = checkAccept.isChecked();
        sendGwtMessage(gwtMsg);
        
        // Note, that this shows how process logic leaks into 
        // the client code, which is not correct.
        // Instead, the process should send a message when request data is required.
        if (checkAccept.isChecked() == false)
        {
          setVisiblePanel(getRequestPanel());
          labelMessage.setText(null);
        }
      }
      if (sender == buttonSubmitConfirm)
      {
        setVisiblePanel(getRequestPanel());
        initRequestPanel(getDefaultData());
        labelMessage.setText(null);
      }
    }
  }

  private void sendGwtMessage(GwtMessage gwtMsg)
  {
    sampleRemoteService.sendMessage(gwtMsg, new MessageCallback());
  }
  
  class MessageCallback implements AsyncCallback
  {
    public void onSuccess(Object result)
    {
      sampleRemoteService.getMessage(this);
      if (result instanceof GwtMessage)
      {
        if (result instanceof OfferMessage)
        {
          labelMessage.setText("Airline Offer");
          setVisiblePanel(getOfferPanel());
          initOfferPanel((OfferMessage)result);
        }
        else if (result instanceof ConfirmMessage)
        {
          labelMessage.setText("Order Confirmation");
          setVisiblePanel(getConfirmPanel());
          initConfirmPanel((ConfirmMessage)result);
        }
        else if (result instanceof InvalidDataMessage)
        {
          labelMessage.setText("Invalid Request Data");
        }
        else if (result instanceof NotAvailableMessage)
        {
          labelMessage.setText("Seats not Available");
        }
        else
        {
          throw new IllegalStateException("Not Implemented: " + result);
        }
      }
    }

    public void onFailure(Throwable caught)
    {
      labelMessage.setText("Error: " + caught.getMessage());
    }
  }
}
