/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.HasWide;
import org.gjt.jclasslib.bytecode.Instruction;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/gjt/jclasslib/bytecode/ImmediateByteInstruction;", "Lorg/gjt/jclasslib/bytecode/Instruction;", "Lorg/gjt/jclasslib/bytecode/HasWide;", "opcode", "Lorg/gjt/jclasslib/bytecode/Opcode;", "isWide", "", "immediateByte", "", "(Lorg/gjt/jclasslib/bytecode/Opcode;ZI)V", "getImmediateByte", "()I", "setImmediateByte", "(I)V", "()Z", "setWide", "(Z)V", "size", "getSize", "read", "", "input", "Lorg/gjt/jclasslib/io/ByteCodeInput;", "write", "output", "Lorg/gjt/jclasslib/io/ByteCodeOutput;", "data"})
public abstract class ImmediateByteInstruction
extends Instruction
implements HasWide {
    private boolean isWide;
    private int immediateByte;

    public ImmediateByteInstruction(@NotNull Opcode opcode, boolean isWide, int immediateByte) {
        Intrinsics.checkNotNullParameter((Object)opcode, (String)"opcode");
        super(opcode);
        this.isWide = isWide;
        this.immediateByte = immediateByte;
    }

    @Override
    public boolean isWide() {
        return this.isWide;
    }

    @Override
    public void setWide(boolean bl) {
        this.isWide = bl;
    }

    public final int getImmediateByte() {
        return this.immediateByte;
    }

    public final void setImmediateByte(int n) {
        this.immediateByte = n;
    }

    @Override
    public int getSize() {
        return super.getSize() + (this.isWide() ? 2 : 1);
    }

    @Override
    public void read(@NotNull ByteCodeInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        this.immediateByte = this.isWide() ? input.readUnsignedShort() : input.readUnsignedByte();
    }

    @Override
    public void write(@NotNull ByteCodeOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        if (this.isWide()) {
            output.writeShort(this.immediateByte);
        } else {
            output.writeByte(this.immediateByte);
        }
    }
}

