/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.bytecode.Opcode;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/gjt/jclasslib/bytecode/TableSwitchInstruction;", "Lorg/gjt/jclasslib/bytecode/PaddedInstruction;", "()V", "defaultOffset", "", "getDefaultOffset", "()I", "setDefaultOffset", "(I)V", "highByte", "getHighByte", "setHighByte", "jumpOffsets", "", "getJumpOffsets", "()[I", "setJumpOffsets", "([I)V", "lowByte", "getLowByte", "setLowByte", "size", "getSize", "read", "", "input", "Lorg/gjt/jclasslib/io/ByteCodeInput;", "write", "output", "Lorg/gjt/jclasslib/io/ByteCodeOutput;", "data"})
public final class TableSwitchInstruction
extends PaddedInstruction {
    private int defaultOffset;
    private int lowByte;
    private int highByte;
    @NotNull
    private int[] jumpOffsets = new int[0];

    public TableSwitchInstruction() {
        super(Opcode.TABLESWITCH);
    }

    public final int getDefaultOffset() {
        return this.defaultOffset;
    }

    public final void setDefaultOffset(int n) {
        this.defaultOffset = n;
    }

    public final int getLowByte() {
        return this.lowByte;
    }

    public final void setLowByte(int n) {
        this.lowByte = n;
    }

    public final int getHighByte() {
        return this.highByte;
    }

    public final void setHighByte(int n) {
        this.highByte = n;
    }

    @NotNull
    public final int[] getJumpOffsets() {
        return this.jumpOffsets;
    }

    public final void setJumpOffsets(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.jumpOffsets = nArray;
    }

    @Override
    public int getSize() {
        return super.getSize() + 12 + 4 * this.jumpOffsets.length;
    }

    @Override
    public void read(@NotNull ByteCodeInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super.read(input);
        this.defaultOffset = input.readInt();
        this.lowByte = input.readInt();
        this.highByte = input.readInt();
        int numberOfOffsets = this.highByte - this.lowByte + 1;
        this.jumpOffsets = new int[numberOfOffsets];
        for (int i = 0; i < numberOfOffsets; ++i) {
            this.jumpOffsets[i] = input.readInt();
        }
    }

    @Override
    public void write(@NotNull ByteCodeOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.writeInt(this.defaultOffset);
        output.writeInt(this.lowByte);
        output.writeInt(this.highByte);
        for (int jumpOffset : this.jumpOffsets) {
            output.writeInt(jumpOffset);
        }
    }
}

