/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.io.CountedDataInputStream;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.Package;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/gjt/jclasslib/io/ClassFileReader;", "", "()V", "readFromClassPath", "Lorg/gjt/jclasslib/structures/ClassFile;", "classPath", "", "", "packageName", "className", "suppressEOF", "", "([Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)Lorg/gjt/jclasslib/structures/ClassFile;", "readFromFile", "file", "Ljava/io/File;", "readFromInputStream", "stream", "Ljava/io/InputStream;", "wrapForDebug", "Ljava/io/DataInputStream;", "data"})
public final class ClassFileReader {
    @NotNull
    public static final ClassFileReader INSTANCE = new ClassFileReader();

    private ClassFileReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClassFile readFromClassPath(@NotNull String[] classPath, @NotNull String packageName, @NotNull String className, boolean suppressEOF) throws InvalidByteCodeException, IOException {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String relativePath = StringsKt.replace$default((String)packageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + (((CharSequence)packageName).length() == 0 ? "" : File.separator) + className + ".class";
        String jarRelativePath = StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        String[] stringArray = classPath;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var14_20 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean bl = false;
            if (!p0.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File classPathEntry = (File)element$iv;
            boolean bl = false;
            if (classPathEntry.isDirectory()) {
                File testFile = new File(classPathEntry, relativePath);
                if (!testFile.exists()) continue;
                return ClassFileReader.readFromFile(testFile, suppressEOF);
            }
            if (!classPathEntry.isFile()) continue;
            Closeable closeable = new JarFile(classPathEntry);
            Throwable throwable = null;
            try {
                JarFile jarFile = (JarFile)closeable;
                boolean bl2 = false;
                JarEntry jarEntry = jarFile.getJarEntry(jarRelativePath);
                if (jarEntry != null) {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jarFile.getInputStream(jarEntry)");
                    ClassFile classFile = ClassFileReader.readFromInputStream(inputStream, suppressEOF);
                    return classFile;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return null;
    }

    public static /* synthetic */ ClassFile readFromClassPath$default(String[] stringArray, String string, String string2, boolean bl, int n, Object object) throws InvalidByteCodeException, IOException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return ClassFileReader.readFromClassPath(stringArray, string, string2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassFile readFromFile(@NotNull File file, boolean suppressEOF) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ClassFileReader.readFromInputStream(new FileInputStream(file), suppressEOF);
    }

    public static /* synthetic */ ClassFile readFromFile$default(File file, boolean bl, int n, Object object) throws InvalidByteCodeException, IOException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ClassFileReader.readFromFile(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassFile readFromInputStream(@NotNull InputStream stream, boolean suppressEOF) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ClassFile classFile = new ClassFile();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(stream);
        Closeable closeable = INSTANCE.wrapForDebug(bufferedInputStream);
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            boolean bl = false;
            if (suppressEOF) {
                try {
                    classFile.read(it);
                }
                catch (EOFException e) {
                    if (Package.isDebug()) {
                        Package.debug("A suppressed end-of-file occurred while reading the class file: " + e.getMessage(), it);
                    }
                }
            } else {
                classFile.read(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return classFile;
    }

    public static /* synthetic */ ClassFile readFromInputStream$default(InputStream inputStream, boolean bl, int n, Object object) throws InvalidByteCodeException, IOException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ClassFileReader.readFromInputStream(inputStream, bl);
    }

    private final DataInputStream wrapForDebug(InputStream $this$wrapForDebug) {
        return Package.isDebug() ? (DataInputStream)new CountedDataInputStream($this$wrapForDebug) : new DataInputStream($this$wrapForDebug);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final ClassFile readFromClassPath(@NotNull String[] classPath, @NotNull String packageName, @NotNull String className) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return ClassFileReader.readFromClassPath$default(classPath, packageName, className, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassFile readFromFile(@NotNull File file) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ClassFileReader.readFromFile$default(file, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassFile readFromInputStream(@NotNull InputStream stream) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return ClassFileReader.readFromInputStream$default(stream, false, 2, null);
    }
}

