/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.io.CountedDataOutputStream;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.Package;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/gjt/jclasslib/io/ClassFileWriter;", "", "()V", "writeToByteArray", "", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "writeToFile", "", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "wrapForDebug", "Ljava/io/DataOutputStream;", "Ljava/io/OutputStream;", "data"})
public final class ClassFileWriter {
    @NotNull
    public static final ClassFileWriter INSTANCE = new ClassFileWriter();

    private ClassFileWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void writeToFile(@NotNull File file, @NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Closeable closeable = new DataOutputStream(INSTANCE.wrapForDebug(new BufferedOutputStream(new FileOutputStream(file))));
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            classFile.write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmStatic
    public static final void writeToFile(@NotNull Path path, @NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        ClassFileWriter.writeToFile(file, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final byte[] writeToByteArray(@NotNull ClassFile classFile) throws InvalidByteCodeException, IOException {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Closeable closeable = INSTANCE.wrapForDebug(result);
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            classFile.write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = result.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"result.toByteArray()");
        return byArray;
    }

    private final DataOutputStream wrapForDebug(OutputStream $this$wrapForDebug) {
        return Package.isDebug() ? (DataOutputStream)new CountedDataOutputStream($this$wrapForDebug) : new DataOutputStream($this$wrapForDebug);
    }
}

