/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.gjt.jclasslib.structures.AttributeContainer;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.Package;
import org.gjt.jclasslib.structures.Structure;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010.\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0014J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\t\"\u0004\b$\u0010\u000bR\u0011\u0010%\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000fR\u0011\u0010'\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0011\u0010)\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010!R\u001a\u0010+\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\t\"\u0004\b-\u0010\u000b\u00a8\u00066"}, d2={"Lorg/gjt/jclasslib/structures/ClassMember;", "Lorg/gjt/jclasslib/structures/Structure;", "Lorg/gjt/jclasslib/structures/AttributeContainer;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "accessFlags", "", "getAccessFlags", "()I", "setAccessFlags", "(I)V", "accessFlagsVerbose", "", "getAccessFlagsVerbose", "()Ljava/lang/String;", "attributes", "", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "getAttributes", "()[Lorg/gjt/jclasslib/structures/AttributeInfo;", "setAttributes", "([Lorg/gjt/jclasslib/structures/AttributeInfo;)V", "[Lorg/gjt/jclasslib/structures/AttributeInfo;", "getClassFile", "()Lorg/gjt/jclasslib/structures/ClassFile;", "debugInfo", "getDebugInfo", "descriptor", "getDescriptor", "descriptorConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getDescriptorConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "descriptorIndex", "getDescriptorIndex", "setDescriptorIndex", "formattedAccessFlags", "getFormattedAccessFlags", "name", "getName", "nameConstant", "getNameConstant", "nameIndex", "getNameIndex", "setNameIndex", "formatAccessFlagsVerbose", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public abstract class ClassMember
extends Structure
implements AttributeContainer {
    @NotNull
    private final ClassFile classFile;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    @NotNull
    private AttributeInfo[] attributes;

    /*
     * WARNING - void declaration
     */
    public ClassMember(@NotNull ClassFile classFile) {
        Object object;
        void $this$getOrPut$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        this.classFile = classFile;
        boolean $i$f$emptyArraySingleton = false;
        Map map = Package.access$getArraySingletons$p();
        KClass key$iv$iv = Reflection.getOrCreateKotlinClass(AttributeInfo.class);
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
        if (value$iv$iv == null) {
            boolean bl = false;
            AttributeInfo[] answer$iv$iv = new AttributeInfo[]{};
            $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        this.attributes = (AttributeInfo[])((Object[])object);
    }

    @NotNull
    protected final ClassFile getClassFile() {
        return this.classFile;
    }

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public final int getNameIndex() {
        return this.nameIndex;
    }

    public final void setNameIndex(int n) {
        this.nameIndex = n;
    }

    @NotNull
    public final ConstantUtf8Info getNameConstant() {
        return this.classFile.getConstantPoolUtf8Entry(this.nameIndex);
    }

    public final int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public final void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    @NotNull
    public final ConstantUtf8Info getDescriptorConstant() {
        return this.classFile.getConstantPoolUtf8Entry(this.descriptorIndex);
    }

    @Override
    @NotNull
    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(@NotNull AttributeInfo[] attributeInfoArray) {
        Intrinsics.checkNotNullParameter((Object)attributeInfoArray, (String)"<set-?>");
        this.attributes = attributeInfoArray;
    }

    @NotNull
    public final String getName() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolUtf8Entry(this.nameIndex).getString();
    }

    @NotNull
    public final String getDescriptor() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolUtf8Entry(this.descriptorIndex).getString();
    }

    @NotNull
    public final String getFormattedAccessFlags() {
        return this.formatFlags(this.accessFlags);
    }

    @NotNull
    public final String getAccessFlagsVerbose() {
        return this.formatAccessFlagsVerbose(this.accessFlags);
    }

    @NotNull
    protected abstract String formatAccessFlagsVerbose(int var1);

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.accessFlags = input.readUnsignedShort();
        this.nameIndex = input.readUnsignedShort();
        this.descriptorIndex = input.readUnsignedShort();
        this.readAttributes(this, input, this.classFile);
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeShort(this.accessFlags);
        output.writeShort(this.nameIndex);
        output.writeShort(this.descriptorIndex);
        this.writeAttributes(this, output);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with accessFlags " + this.getAccessFlagsVerbose() + ", nameIndex " + this.nameIndex + ", descriptorIndex " + this.descriptorIndex + ", " + this.getAttributes().length + " attributes";
    }

    @Override
    @Nullable
    public <T extends AttributeInfo> T findAttribute(@NotNull Class<T> attributeClass) {
        return AttributeContainer.DefaultImpls.findAttribute(this, attributeClass);
    }

    @Override
    public int getTotalAttributesLength() {
        return AttributeContainer.DefaultImpls.getTotalAttributesLength(this);
    }

    @Override
    public void readAttributes(@NotNull AttributeContainer $this$readAttributes, @NotNull DataInput input, @NotNull ClassFile classFile) {
        AttributeContainer.DefaultImpls.readAttributes(this, $this$readAttributes, input, classFile);
    }

    @Override
    public void writeAttributes(@NotNull AttributeContainer $this$writeAttributes, @NotNull DataOutput output) {
        AttributeContainer.DefaultImpls.writeAttributes(this, $this$writeAttributes, output);
    }
}

