/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000e\u00a8\u0006#"}, d2={"Lorg/gjt/jclasslib/structures/attributes/EnclosingMethodAttribute;", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "classInfoConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "getClassInfoConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "classInfoIndex", "", "getClassInfoIndex", "()I", "setClassInfoIndex", "(I)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "methodInfoConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "getMethodInfoConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "methodInfoIndex", "getMethodInfoIndex", "setMethodInfoIndex", "getAttributeLength", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "Companion", "data"})
public final class EnclosingMethodAttribute
extends AttributeInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int classInfoIndex;
    private int methodInfoIndex;
    @NotNull
    public static final String ATTRIBUTE_NAME = "EnclosingMethod";

    public EnclosingMethodAttribute(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getClassInfoIndex() {
        return this.classInfoIndex;
    }

    public final void setClassInfoIndex(int n) {
        this.classInfoIndex = n;
    }

    @NotNull
    public final ConstantClassInfo getClassInfoConstant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntry(this.classInfoIndex, ConstantClassInfo.class);
    }

    public final int getMethodInfoIndex() {
        return this.methodInfoIndex;
    }

    public final void setMethodInfoIndex(int n) {
        this.methodInfoIndex = n;
    }

    @NotNull
    public final ConstantNameAndTypeInfo getMethodInfoConstant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntry(this.methodInfoIndex, ConstantNameAndTypeInfo.class);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.classInfoIndex = input.readUnsignedShort();
        this.methodInfoIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeShort(this.classInfoIndex);
        output.writeShort(this.methodInfoIndex);
    }

    @Override
    public int getAttributeLength() {
        return 4;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with classInfoIndex " + this.classInfoIndex + " and methodInfoIndex " + this.methodInfoIndex;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/gjt/jclasslib/structures/attributes/EnclosingMethodAttribute$Companion;", "", "()V", "ATTRIBUTE_NAME", "", "data"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

