/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantDynamic;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "bootstrapMethodAttributeIndex", "", "getBootstrapMethodAttributeIndex", "()I", "setBootstrapMethodAttributeIndex", "(I)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "nameAndTypeIndex", "getNameAndTypeIndex", "setNameAndTypeIndex", "nameAndTypeInfo", "Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "getNameAndTypeInfo", "()Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public abstract class ConstantDynamic
extends AbstractConstant {
    private int bootstrapMethodAttributeIndex;
    private int nameAndTypeIndex;

    public ConstantDynamic(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getBootstrapMethodAttributeIndex() {
        return this.bootstrapMethodAttributeIndex;
    }

    public final void setBootstrapMethodAttributeIndex(int n) {
        this.bootstrapMethodAttributeIndex = n;
    }

    public final int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public final void setNameAndTypeIndex(int n) {
        this.nameAndTypeIndex = n;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getNameAndTypeInfo().getName() + ", BootstrapMethods #" + this.bootstrapMethodAttributeIndex;
    }

    @NotNull
    public final ConstantNameAndTypeInfo getNameAndTypeInfo() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntry(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.bootstrapMethodAttributeIndex = input.readUnsignedShort();
        this.nameAndTypeIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(this.getConstantType().getTag());
        output.writeShort(this.bootstrapMethodAttributeIndex);
        output.writeShort(this.nameAndTypeIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with bootstrapMethodAttributeIndex " + this.bootstrapMethodAttributeIndex + " and nameAndTypeIndex " + this.nameAndTypeIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantDynamic) || ((ConstantDynamic)other).getConstantType() != this.getConstantType()) {
            return false;
        }
        return super.equals(other) && ((ConstantDynamic)other).bootstrapMethodAttributeIndex == this.bootstrapMethodAttributeIndex && ((ConstantDynamic)other).nameAndTypeIndex == this.nameAndTypeIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.bootstrapMethodAttributeIndex ^ this.nameAndTypeIndex;
    }
}

