/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantLargeNumeric;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "formattedHighBytes", "getFormattedHighBytes", "formattedLowBytes", "getFormattedLowBytes", "highBytes", "", "getHighBytes", "()I", "setHighBytes", "(I)V", "lowBytes", "getLowBytes", "setLowBytes", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public abstract class ConstantLargeNumeric
extends AbstractConstant {
    private int highBytes;
    private int lowBytes;

    public ConstantLargeNumeric(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getHighBytes() {
        return this.highBytes;
    }

    public final void setHighBytes(int n) {
        this.highBytes = n;
    }

    public final int getLowBytes() {
        return this.lowBytes;
    }

    public final void setLowBytes(int n) {
        this.lowBytes = n;
    }

    @NotNull
    public final String getFormattedHighBytes() {
        return this.formatBytes(this.highBytes);
    }

    @NotNull
    public final String getFormattedLowBytes() {
        return this.formatBytes(this.lowBytes);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.highBytes = input.readInt();
        this.lowBytes = input.readInt();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeInt(this.highBytes);
        output.writeInt(this.lowBytes);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with high_bytes " + this.highBytes + " and low_bytes " + this.lowBytes;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantLargeNumeric)) {
            return false;
        }
        return super.equals(other) && ((ConstantLargeNumeric)other).highBytes == this.highBytes && ((ConstantLargeNumeric)other).lowBytes == this.lowBytes;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.highBytes ^ this.lowBytes;
    }
}

