/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\f\u00a8\u0006'"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantMethodTypeInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "descriptorIndex", "", "getDescriptorIndex", "()I", "setDescriptorIndex", "(I)V", "name", "getName", "typeConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getTypeConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantMethodTypeInfo
extends AbstractConstant {
    private int descriptorIndex;

    public ConstantMethodTypeInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public final void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.METHOD_TYPE;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getName();
    }

    @NotNull
    public final String getName() throws InvalidByteCodeException {
        return this.getTypeConstant().getString();
    }

    @NotNull
    public final ConstantUtf8Info getTypeConstant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolUtf8Entry(this.descriptorIndex);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.descriptorIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.METHOD_TYPE.getTag());
        output.writeShort(this.descriptorIndex);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantMethodTypeInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantMethodTypeInfo)other).descriptorIndex == this.descriptorIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.descriptorIndex;
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with descriptorIndex " + this.descriptorIndex;
    }
}

