/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006("}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantReference;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "classConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "getClassConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantClassInfo;", "classIndex", "", "getClassIndex", "()I", "setClassIndex", "(I)V", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "nameAndTypeConstant", "Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "getNameAndTypeConstant", "()Lorg/gjt/jclasslib/structures/constants/ConstantNameAndTypeInfo;", "nameAndTypeIndex", "getNameAndTypeIndex", "setNameAndTypeIndex", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public abstract class ConstantReference
extends AbstractConstant {
    private int classIndex;
    private int nameAndTypeIndex;

    public ConstantReference(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final void setClassIndex(int n) {
        this.classIndex = n;
    }

    public final int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public final void setNameAndTypeIndex(int n) {
        this.nameAndTypeIndex = n;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getClassConstant().getVerbose() + "." + this.getNameAndTypeConstant().getVerbose();
    }

    @NotNull
    public final ConstantClassInfo getClassConstant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntry(this.classIndex, ConstantClassInfo.class);
    }

    @NotNull
    public final ConstantNameAndTypeInfo getNameAndTypeConstant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolEntry(this.nameAndTypeIndex, ConstantNameAndTypeInfo.class);
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.classIndex = input.readUnsignedShort();
        this.nameAndTypeIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeShort(this.classIndex);
        output.writeShort(this.nameAndTypeIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with classIndex " + this.classIndex + " and nameAndTypeIndex " + this.nameAndTypeIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantReference)) {
            return false;
        }
        return super.equals(other) && ((ConstantReference)other).classIndex == this.classIndex && ((ConstantReference)other).nameAndTypeIndex == this.nameAndTypeIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.classIndex ^ this.nameAndTypeIndex;
    }
}

