/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006%"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantStringInfo;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "stringIndex", "", "getStringIndex", "()I", "setStringIndex", "(I)V", "utf8Constant", "Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "getUtf8Constant", "()Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantStringInfo
extends AbstractConstant {
    private int stringIndex;

    public ConstantStringInfo(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
    }

    public final int getStringIndex() {
        return this.stringIndex;
    }

    public final void setStringIndex(int n) {
        this.stringIndex = n;
    }

    @NotNull
    public final ConstantUtf8Info getUtf8Constant() throws InvalidByteCodeException {
        return this.getClassFile().getConstantPoolUtf8Entry(this.stringIndex);
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.STRING;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.getUtf8Constant().getString();
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.stringIndex = input.readUnsignedShort();
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.STRING.getTag());
        output.writeShort(this.stringIndex);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with stringIndex " + this.stringIndex;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantStringInfo)) {
            return false;
        }
        return super.equals(other) && ((ConstantStringInfo)other).stringIndex == this.stringIndex;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.stringIndex;
    }
}

