/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gjt.jclasslib.structures.AbstractConstant;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ConstantType;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/gjt/jclasslib/structures/constants/ConstantUtf8Info;", "Lorg/gjt/jclasslib/structures/AbstractConstant;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "bytes", "", "getBytes", "()[B", "constantType", "Lorg/gjt/jclasslib/structures/ConstantType;", "getConstantType", "()Lorg/gjt/jclasslib/structures/ConstantType;", "debugInfo", "", "getDebugInfo", "()Ljava/lang/String;", "string", "getString", "setString", "(Ljava/lang/String;)V", "verbose", "getVerbose", "equals", "", "other", "", "hashCode", "", "readData", "", "input", "Ljava/io/DataInput;", "writeData", "output", "Ljava/io/DataOutput;", "data"})
public final class ConstantUtf8Info
extends AbstractConstant {
    @NotNull
    private String string;

    public ConstantUtf8Info(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(classFile);
        this.string = "";
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    public final void setString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.string = string;
    }

    @Override
    @NotNull
    public ConstantType getConstantType() {
        return ConstantType.UTF8;
    }

    @Override
    @NotNull
    public String getVerbose() throws InvalidByteCodeException {
        return this.string;
    }

    @NotNull
    public final byte[] getBytes() {
        String string = this.string;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Override
    protected void readData(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readUTF();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readUTF()");
        this.string = string;
    }

    @Override
    protected void writeData(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeByte(ConstantType.UTF8.getTag());
        output.writeUTF(this.string);
    }

    @Override
    @NotNull
    protected String getDebugInfo() {
        return "with length " + this.string.length() + " (\"" + this.string + "\")";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConstantUtf8Info)) {
            return false;
        }
        return super.equals(other) && Intrinsics.areEqual((Object)((ConstantUtf8Info)other).string, (Object)this.string);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.string.hashCode();
    }
}

