/**
 * Licensed to jclouds, Inc. (jclouds) under one or more
 * contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  jclouds licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jclouds.openstack.v2_0.features;

import java.util.Set;
import org.jclouds.openstack.v2_0.domain.Extension;

/**
 * Provides asynchronous access to Extensions via their REST API.
 * <p/>
 * 
 * @see ExtensionAsyncApi
 * @see <a href=
 *      "http://docs.openstack.org/api/openstack-compute/2/content/Extensions-d1e1444.html"
 *      />
 * @author Adrian Cole
 */
public interface ExtensionApi {

   /**
    * List all available extensions
    * 
    * @return all extensions
    */
   Set<? extends Extension> list();

   /**
    * Extensions may also be queried individually by their unique alias.
    * 
    * @param id
    *           id of the extension
    * @return extension or null if not found
    */
   Extension get(String alias);

}
