/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Strings2;

@Singleton
public class ParseAWSErrorFromXmlContent
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    final AWSUtils utils;

    @Inject
    public ParseAWSErrorFromXmlContent(AWSUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        Object exception = new HttpResponseException(command, response);
        try {
            String message;
            AWSError error = null;
            byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            String string = message = data != null ? new String(data) : null;
            if (response.getPayload() != null) {
                String contentType = response.getPayload().getContentMetadata().getContentType();
                if (contentType != null && (contentType.indexOf("xml") != -1 || contentType.indexOf("unknown") != -1)) {
                    error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
                    if (error != null) {
                        message = error.getMessage();
                        exception = new AWSResponseException(command, response, error);
                    } else {
                        exception = new HttpResponseException(command, response, message);
                    }
                } else {
                    try {
                        message = Strings2.toString((InputSupplier)response.getPayload());
                        exception = new HttpResponseException(command, response, message);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            exception = this.refineException(command, response, (Exception)exception, error, message);
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
            command.setException((Exception)exception);
        }
    }

    protected Exception refineException(HttpCommand command, HttpResponse response, Exception exception, AWSError error, String message) {
        String errorCode = error != null && error.getCode() != null ? error.getCode() : null;
        switch (response.getStatusCode()) {
            case 400: {
                if ("UnsupportedOperation".equals(errorCode)) {
                    exception = new UnsupportedOperationException(message, exception);
                    break;
                }
                if ("AddressLimitExceeded".equals(errorCode)) {
                    exception = new InsufficientResourcesException(message, (Throwable)exception);
                    break;
                }
                if (errorCode != null && (errorCode.indexOf("NotFound") != -1 || errorCode.endsWith(".Unknown"))) {
                    exception = new ResourceNotFoundException(message, (Throwable)exception);
                    break;
                }
                if ("IncorrectState".equals(errorCode) || errorCode != null && (error.getCode().endsWith(".Duplicate") || error.getCode().endsWith(".InUse")) || message != null && (message.indexOf("already exists") != -1 || message.indexOf("is in use") != -1)) {
                    exception = new IllegalStateException(message, exception);
                    break;
                }
                if (errorCode != null && errorCode.indexOf("AuthFailure") != -1) {
                    exception = new AuthorizationException(message, (Throwable)exception);
                    break;
                }
                if (message == null || message.indexOf("Invalid id") == -1 && message.indexOf("Failed to bind") == -1) break;
                exception = new IllegalArgumentException(message, exception);
                break;
            }
            case 401: 
            case 403: {
                exception = new AuthorizationException(message, (Throwable)exception);
                break;
            }
            case 404: {
                if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                exception = new ResourceNotFoundException(message, (Throwable)exception);
                break;
            }
            case 409: {
                exception = new IllegalStateException(message, exception);
            }
        }
        return exception;
    }
}

