/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.config;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import javax.inject.Inject;
import org.jclouds.blobstore.BlobMap;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.InputStreamMap;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.internal.BlobMapImpl;
import org.jclouds.blobstore.internal.InputStreamMapImpl;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.GetBlobsInListStrategy;
import org.jclouds.blobstore.strategy.PutBlobsStrategy;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;
import org.jclouds.crypto.Crypto;

public class BlobStoreMapModule
extends AbstractModule {
    protected void configure() {
        this.bind(BlobMap.Factory.class).to(BlobMapFactory.class).in(Scopes.SINGLETON);
        this.bind(InputStreamMap.Factory.class).to(InputStreamMapFactory.class).in(Scopes.SINGLETON);
    }

    private static class InputStreamMapFactory
    implements InputStreamMap.Factory {
        @Inject
        BlobStore connection;
        @Inject
        Blob.Factory blobFactory;
        @Inject
        GetBlobsInListStrategy getAllBlobs;
        @Inject
        ContainsValueInListStrategy containsValueStrategy;
        @Inject
        PutBlobsStrategy putBlobsStrategy;
        @Inject
        Crypto crypto;
        @Inject
        ListContainerAndRecurseThroughFolders listStrategy;

        private InputStreamMapFactory() {
        }

        @Override
        public InputStreamMap create(String containerName, ListContainerOptions options) {
            return new InputStreamMapImpl(this.connection, this.blobFactory, this.getAllBlobs, this.listStrategy, this.containsValueStrategy, this.putBlobsStrategy, containerName, options, this.crypto);
        }
    }

    private static class BlobMapFactory
    implements BlobMap.Factory {
        @Inject
        BlobStore connection;
        @Inject
        GetBlobsInListStrategy getAllBlobs;
        @Inject
        ContainsValueInListStrategy containsValueStrategy;
        @Inject
        PutBlobsStrategy putBlobsStrategy;
        @Inject
        ListContainerAndRecurseThroughFolders listStrategy;

        private BlobMapFactory() {
        }

        @Override
        public BlobMap create(String containerName, ListContainerOptions options) {
            return new BlobMapImpl(this.connection, this.getAllBlobs, this.containsValueStrategy, this.putBlobsStrategy, this.listStrategy, containerName, options);
        }
    }
}

