/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import org.jclouds.blobstore.domain.PageSet;

public class PageSetImpl<T>
extends LinkedHashSet<T>
implements PageSet<T> {
    private static final long serialVersionUID = -7133632087734650835L;
    protected final String marker;

    public PageSetImpl(Iterable<? extends T> contents, @Nullable String nextMarker) {
        Iterables.addAll((Collection)this, contents);
        this.marker = nextMarker;
    }

    @Override
    public String getNextMarker() {
        return this.marker;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.marker == null ? 0 : this.marker.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageSetImpl other = (PageSetImpl)obj;
        return !(this.marker == null ? other.marker != null : !this.marker.equals(other.marker));
    }
}

