/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.domain.Location;
import org.jclouds.domain.internal.ResourceMetadataImpl;

public class StorageMetadataImpl
extends ResourceMetadataImpl<StorageType>
implements StorageMetadata,
Serializable {
    private static final long serialVersionUID = -280558162576368264L;
    @Nullable
    private final String eTag;
    @Nullable
    private final Date lastModified;
    private final StorageType type;

    public StorageMetadataImpl(StorageType type, @Nullable String id, @Nullable String name, @Nullable Location location, @Nullable URI uri, @Nullable String eTag, @Nullable Date lastModified, Map<String, String> userMetadata) {
        super(id, name, location, uri, userMetadata);
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.type = (StorageType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
    }

    @Override
    public StorageType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.eTag == null ? 0 : this.eTag.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageMetadataImpl other = (StorageMetadataImpl)obj;
        if (this.eTag == null ? other.eTag != null : !this.eTag.equals(other.eTag)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }
}

