/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearContainerStrategy;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.blobstore.strategy.ListContainerStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllKeysInList
implements ClearListStrategy,
ClearContainerStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final ListContainerStrategy listContainer;
    protected final BackoffLimitedRetryHandler retryHandler;
    private final ExecutorService userExecutor;
    protected final AsyncBlobStore connection;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    DeleteAllKeysInList(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore connection, ListContainerStrategy listContainer, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.connection = connection;
        this.listContainer = listContainer;
        this.retryHandler = retryHandler;
    }

    @Override
    public void execute(String containerName) {
        this.execute(containerName, ListContainerOptions.Builder.recursive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String containerName, ListContainerOptions options) {
        String message;
        String string = message = options.getDir() != null ? String.format("clearing path %s/%s", containerName, options.getDir()) : String.format("clearing container %s", containerName);
        if (options.isRecursive()) {
            message = message + " recursively";
        }
        Map exceptions = Maps.newHashMap();
        Iterable<? extends StorageMetadata> toDelete = this.getResourcesToDelete(containerName, options);
        for (int i = 0; i < 3; ++i) {
            HashMap responses = Maps.newHashMap();
            try {
                for (StorageMetadata storageMetadata : toDelete) {
                    String fullPath = this.parentIsFolder(options, storageMetadata) ? options.getDir() + "/" + storageMetadata.getName() : storageMetadata.getName();
                    switch (storageMetadata.getType()) {
                        case BLOB: {
                            responses.put(storageMetadata, this.connection.removeBlob(containerName, fullPath));
                            break;
                        }
                        case FOLDER: {
                            if (options.isRecursive() && !fullPath.equals(options.getDir())) {
                                this.execute(containerName, options.clone().inDirectory(fullPath));
                            }
                            responses.put(storageMetadata, this.connection.deleteDirectory(containerName, fullPath));
                            break;
                        }
                        case RELATIVE_PATH: {
                            if (options.isRecursive() && !fullPath.equals(options.getDir())) {
                                this.execute(containerName, options.clone().inDirectory(fullPath));
                            }
                            responses.put(storageMetadata, this.connection.deleteDirectory(containerName, storageMetadata.getName()));
                            break;
                        }
                        case CONTAINER: {
                            throw new IllegalArgumentException("Container type not supported");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)message);
                toDelete = this.getResourcesToDelete(containerName, options);
                if (Iterables.size(toDelete) == 0) break;
                if (exceptions.size() > 0) {
                    toDelete = Iterables.concat(exceptions.keySet(), toDelete);
                    this.retryHandler.imposeBackoffExponentialDelay(i + 1, message);
                }
                throw throwable;
            }
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)message);
            toDelete = this.getResourcesToDelete(containerName, options);
            if (Iterables.size(toDelete) == 0) break;
            if (exceptions.size() <= 0) continue;
            toDelete = Iterables.concat(exceptions.keySet(), (Iterable)toDelete);
            this.retryHandler.imposeBackoffExponentialDelay(i + 1, message);
            continue;
        }
        if (exceptions.size() > 0) {
            throw new BlobRuntimeException(String.format("error %s: %s", message, exceptions));
        }
        assert (Iterables.size(toDelete) == 0) : String.format("items remaining %s: %s", message, toDelete);
    }

    private boolean parentIsFolder(ListContainerOptions options, StorageMetadata md) {
        return options.getDir() != null && md.getName().indexOf(47) == -1;
    }

    private Iterable<? extends StorageMetadata> getResourcesToDelete(String containerName, final ListContainerOptions options) {
        Iterable toDelete = Iterables.filter(this.listContainer.execute(containerName, options), (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                switch (input.getType()) {
                    case BLOB: {
                        return true;
                    }
                    case FOLDER: 
                    case RELATIVE_PATH: {
                        if (!options.isRecursive()) break;
                        return true;
                    }
                }
                return false;
            }
        });
        return toDelete;
    }
}

