/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.blobstore.strategy.CountListStrategy;
import org.jclouds.blobstore.strategy.DeleteDirectoryStrategy;
import org.jclouds.blobstore.strategy.GetDirectoryStrategy;
import org.jclouds.blobstore.strategy.MkdirStrategy;
import org.jclouds.blobstore.util.BlobUtils;

@Singleton
public class BlobUtilsImpl
implements BlobUtils {
    protected final Blob.Factory blobFactory;
    protected final ClearListStrategy clearContainerStrategy;
    protected final GetDirectoryStrategy getDirectoryStrategy;
    protected final MkdirStrategy mkdirStrategy;
    protected final DeleteDirectoryStrategy rmDirStrategy;
    protected final CountListStrategy countBlobsStrategy;

    @Inject
    protected BlobUtilsImpl(Blob.Factory blobFactory, ClearListStrategy clearContainerStrategy, GetDirectoryStrategy getDirectoryStrategy, MkdirStrategy mkdirStrategy, CountListStrategy countBlobsStrategy, DeleteDirectoryStrategy rmDirStrategy) {
        this.blobFactory = (Blob.Factory)Preconditions.checkNotNull((Object)blobFactory, (Object)"blobFactory");
        this.clearContainerStrategy = (ClearListStrategy)Preconditions.checkNotNull((Object)clearContainerStrategy, (Object)"clearContainerStrategy");
        this.getDirectoryStrategy = (GetDirectoryStrategy)Preconditions.checkNotNull((Object)getDirectoryStrategy, (Object)"getDirectoryStrategy");
        this.mkdirStrategy = (MkdirStrategy)Preconditions.checkNotNull((Object)mkdirStrategy, (Object)"mkdirStrategy");
        this.rmDirStrategy = (DeleteDirectoryStrategy)Preconditions.checkNotNull((Object)rmDirStrategy, (Object)"rmDirStrategy");
        this.countBlobsStrategy = (CountListStrategy)Preconditions.checkNotNull((Object)countBlobsStrategy, (Object)"countBlobsStrategy");
    }

    @Override
    public Blob newBlob(String name) {
        Blob blob = this.blobFactory.create(null);
        blob.getMetadata().setName(name);
        return blob;
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.getDirectoryStrategy.execute(containerName, directory) != null;
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        this.mkdirStrategy.execute(containerName, directory);
    }

    @Override
    public long countBlobs(String container, ListContainerOptions options) {
        return this.countBlobsStrategy.execute(container, options);
    }

    @Override
    public void clearContainer(String container, ListContainerOptions options) {
        this.clearContainerStrategy.execute(container, options);
    }

    @Override
    public void deleteDirectory(String container, String directory) {
        this.rmDirStrategy.execute(container, directory);
    }
}

