/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;

public class RunNodesException
extends Exception {
    private static final long serialVersionUID = -2272965726680821281L;
    private final String tag;
    private final int count;
    private final Template template;
    private final Set<? extends NodeMetadata> successfulNodes;
    private final Map<? extends NodeMetadata, ? extends Throwable> failedNodes;
    private final Map<?, Exception> executionExceptions;

    public RunNodesException(String tag, int count, Template template, Set<? extends NodeMetadata> successfulNodes, Map<?, Exception> executionExceptions, Map<? extends NodeMetadata, ? extends Throwable> failedNodes) {
        super(String.format("error running %d node%s tag(%s) location(%s) image(%s) size(%s) options(%s)%n%s%n%s", count, count > 1 ? "s" : "", tag, template.getLocation().getId(), template.getImage().getProviderId(), template.getHardware().getProviderId(), template.getOptions(), ComputeServiceUtils.createExecutionErrorMessage(executionExceptions), ComputeServiceUtils.createNodeErrorMessage(failedNodes)));
        this.tag = tag;
        this.count = count;
        this.template = template;
        this.successfulNodes = successfulNodes;
        this.failedNodes = failedNodes;
        this.executionExceptions = executionExceptions;
    }

    public Set<? extends NodeMetadata> getSuccessfulNodes() {
        return this.successfulNodes;
    }

    public Map<?, ? extends Throwable> getExecutionErrors() {
        return this.executionExceptions;
    }

    public Map<? extends NodeMetadata, ? extends Throwable> getNodeErrors() {
        return this.failedNodes;
    }

    public String getTag() {
        return this.tag;
    }

    public int getCount() {
        return this.count;
    }

    public Template getTemplate() {
        return this.template;
    }
}

