/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute;

import java.util.Map;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.scriptbuilder.domain.Statement;

public class RunScriptOnNodesException
extends Exception {
    private static final long serialVersionUID = -2272965726680821281L;
    private final Statement runScript;
    private final RunScriptOptions options;
    private final Map<NodeMetadata, ExecResponse> successfulNodes;
    private final Map<? extends NodeMetadata, ? extends Throwable> failedNodes;
    private final Map<?, Exception> executionExceptions;

    public RunScriptOnNodesException(Statement runScript, @Nullable RunScriptOptions options, Map<NodeMetadata, ExecResponse> successfulNodes, Map<?, Exception> executionExceptions, Map<? extends NodeMetadata, ? extends Throwable> failedNodes) {
        super(String.format("error runScript on filtered nodes options(%s)%n%s%n%s", options, ComputeServiceUtils.createExecutionErrorMessage(executionExceptions), ComputeServiceUtils.createNodeErrorMessage(failedNodes)));
        this.runScript = runScript;
        this.options = options;
        this.successfulNodes = successfulNodes;
        this.failedNodes = failedNodes;
        this.executionExceptions = executionExceptions;
    }

    public Map<NodeMetadata, ExecResponse> getSuccessfulNodes() {
        return this.successfulNodes;
    }

    public Map<?, ? extends Throwable> getExecutionErrors() {
        return this.executionExceptions;
    }

    public Map<? extends NodeMetadata, ? extends Throwable> getNodeErrors() {
        return this.failedNodes;
    }

    public Statement getRunScript() {
        return this.runScript;
    }

    public RunScriptOptions getOptions() {
        return this.options;
    }
}

