/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.InitBuilder;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public class RunScriptOnNodeAsInitScriptUsingSsh
implements RunScriptOnNode {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<NodeMetadata, SshClient> sshFactory;
    protected final NodeMetadata node;
    protected final Statement init;
    protected final String name;
    protected final boolean runAsRoot;
    protected SshClient ssh;

    @AssistedInject
    public RunScriptOnNodeAsInitScriptUsingSsh(Function<NodeMetadata, SshClient> sshFactory, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options) {
        this.sshFactory = (Function)Preconditions.checkNotNull(sshFactory, (Object)"sshFactory");
        this.node = (NodeMetadata)Preconditions.checkNotNull((Object)node, (Object)"node");
        String name = options.getTaskName();
        if (name == null) {
            name = Preconditions.checkNotNull((Object)script, (Object)"script") instanceof InitBuilder ? ((InitBuilder)InitBuilder.class.cast(script)).getInstanceName() : "jclouds-script-" + System.currentTimeMillis();
        }
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.init = Preconditions.checkNotNull((Object)script, (Object)"script") instanceof InitBuilder ? (InitBuilder)InitBuilder.class.cast(script) : RunScriptOnNodeAsInitScriptUsingSsh.createInitScript(name, script);
        this.runAsRoot = options.shouldRunAsRoot();
    }

    public static InitBuilder createInitScript(String name, Statement script) {
        String path = "/tmp/" + name;
        return new InitBuilder(name, path, path, Collections.emptyMap(), Collections.singleton(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResponse call() {
        Preconditions.checkState((this.ssh != null ? 1 : 0) != 0, (Object)"please call init() before invoking call");
        try {
            this.ssh.connect();
            ExecResponse execResponse = this.doCall();
            return execResponse;
        }
        finally {
            if (this.ssh != null) {
                this.ssh.disconnect();
            }
        }
    }

    @Override
    public RunScriptOnNode init() {
        this.ssh = (SshClient)this.sshFactory.apply((Object)this.node);
        return this;
    }

    protected ExecResponse doCall() {
        this.ssh.put(this.name, this.init.render(OsFamily.UNIX));
        this.ssh.exec("chmod 755 " + this.name);
        this.runAction("init");
        return this.runAction("start");
    }

    protected ExecResponse runAction(String action) {
        String command = this.runAsRoot ? this.execScriptAsRoot(action) : this.execScriptAsDefaultUser(action);
        ExecResponse returnVal = this.runCommand(command);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<< %s[%s]", new Object[]{action, returnVal});
        } else {
            this.logger.debug("<< %s(%d)", new Object[]{action, returnVal.getExitCode()});
        }
        return returnVal;
    }

    protected ExecResponse runCommand(String command) {
        this.logger.debug(">> running [%s] as %s@%s", new Object[]{command.replace(this.node.getAdminPassword() != null ? this.node.getAdminPassword() : "XXXXX", "XXXXX"), this.ssh.getUsername(), this.ssh.getHostAddress()});
        ExecResponse returnVal = this.ssh.exec(command);
        return returnVal;
    }

    @VisibleForTesting
    public String execScriptAsRoot(String action) {
        String command = this.node.getCredentials().identity.equals("root") ? "./" + this.name + " " + action : (this.node.getAdminPassword() != null ? String.format("echo '%s'|sudo -S ./%s %s", this.node.getAdminPassword(), this.name, action) : "sudo ./" + this.name + " " + action);
        return command;
    }

    protected String execScriptAsDefaultUser(String action) {
        return "./" + this.name + " " + action;
    }

    @Override
    public NodeMetadata getNode() {
        return this.node;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("node", (Object)this.node).add("name", (Object)this.name).add("runAsRoot", (Object)this.runAsRoot).toString();
    }
}

