/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.predicates.ScriptStatusReturnsZero;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.ssh.SshClient;

public class RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete
extends RunScriptOnNodeAsInitScriptUsingSsh {
    protected final Predicate<ScriptStatusReturnsZero.CommandUsingClient> runScriptNotRunning;

    @Inject
    public RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete(@Named(value="SCRIPT_COMPLETE") Predicate<ScriptStatusReturnsZero.CommandUsingClient> runScriptNotRunning, Function<NodeMetadata, SshClient> sshFactory, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options) {
        super(sshFactory, node, script, options);
        this.runScriptNotRunning = (Predicate)Preconditions.checkNotNull(runScriptNotRunning, (Object)"runScriptNotRunning");
    }

    @Override
    public ExecResponse doCall() {
        ExecResponse returnVal = super.doCall();
        boolean complete = this.runScriptNotRunning.apply((Object)new ScriptStatusReturnsZero.CommandUsingClient("./" + this.name + " status", this.ssh));
        this.logger.debug("<< complete(%s)", new Object[]{complete});
        if (this.logger.isDebugEnabled() || returnVal.getExitCode() != 0) {
            this.logger.debug("<< stdout from %s as %s@%s\n%s", new Object[]{this.name, this.node.getCredentials().identity, Iterables.get(this.node.getPublicAddresses(), (int)0), this.ssh.exec("./" + this.name + " tail").getOutput()});
            this.logger.debug("<< stderr from %s as %s@%s\n%s", new Object[]{this.name, this.node.getCredentials().identity, Iterables.get(this.node.getPublicAddresses(), (int)0), this.ssh.exec("./" + this.name + " tailerr").getOutput()});
        }
        return returnVal;
    }
}

