/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSsh;
import org.jclouds.compute.callables.RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete;
import org.jclouds.compute.callables.RunScriptOnNodeUsingSsh;
import org.jclouds.compute.config.ComputeServiceTimeoutsModule;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.functions.CreateSshClientOncePortIsListeningOnNode;
import org.jclouds.compute.functions.TemplateOptionsToStatement;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.json.Json;
import org.jclouds.location.config.LocationModule;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.RetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.ssh.SshClient;

public abstract class BaseComputeServiceContextModule
extends AbstractModule {
    protected AtomicReference<AuthorizationException> authException = new AtomicReference();

    protected void configure() {
        this.install((Module)new LocationModule(this.authException));
        this.install((Module)new ComputeServiceTimeoutsModule());
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, SshClient>>(){}).to(CreateSshClientOncePortIsListeningOnNode.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<TemplateOptions, Statement>>(){}).to(TemplateOptionsToStatement.class);
        this.install(new FactoryModuleBuilder().implement(RunScriptOnNode.class, (Annotation)Names.named((String)"direct"), RunScriptOnNodeUsingSsh.class).implement(RunScriptOnNode.class, (Annotation)Names.named((String)"blocking"), RunScriptOnNodeAsInitScriptUsingSshAndBlockUntilComplete.class).implement(RunScriptOnNode.class, (Annotation)Names.named((String)"nonblocking"), RunScriptOnNodeAsInitScriptUsingSsh.class).build(RunScriptOnNodeFactoryImpl.Factory.class));
        this.bind(RunScriptOnNode.Factory.class).to(RunScriptOnNodeFactoryImpl.class);
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Callable<Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).implement((TypeLiteral)new TypeLiteral<Function<NodeMetadata, Void>>(){}, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.class).build(CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory.class));
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Callable<RunScriptOnNode>>(){}, InitializeRunScriptOnNodeOrPlaceInBadMap.class).build(InitializeRunScriptOnNodeOrPlaceInBadMap.Factory.class));
    }

    @Provides
    @Singleton
    public Map<OsFamily, Map<String, String>> provideOsVersionMap(ComputeServiceConstants.ReferenceData data, Json json) {
        return (Map)json.fromJson(data.osVersionMapJson, new TypeLiteral<Map<OsFamily, Map<String, String>>>(){}.getType());
    }

    @Provides
    @Named(value="DEFAULT")
    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).osVersionMatches("10.04").os64Bit(true);
    }

    @Provides
    @Named(value="NAMING_CONVENTION")
    @Singleton
    protected String provideNamingConvention() {
        return "%s-%s";
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Image>> provideImageMap(@Memoized Supplier<Set<? extends Image>> images) {
        return Suppliers.compose((Function)new Function<Set<? extends Image>, Map<String, ? extends Image>>(){

            public Map<String, ? extends Image> apply(Set<? extends Image> from) {
                return Maps.uniqueIndex(from, (Function)new Function<Image, String>(){

                    public String apply(Image from) {
                        return from.getId();
                    }
                });
            }
        }, images);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Image>> supplyImageCache(@Named(value="jclouds.session-interval") long seconds, final Supplier<Set<? extends Image>> imageSupplier) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Set<? extends Image>>(){

            public Set<? extends Image> get() {
                return (Set)imageSupplier.get();
            }
        });
    }

    @Provides
    @Singleton
    protected Supplier<Map<String, ? extends Hardware>> provideSizeMap(@Memoized Supplier<Set<? extends Hardware>> sizes) {
        return Suppliers.compose((Function)new Function<Set<? extends Hardware>, Map<String, ? extends Hardware>>(){

            public Map<String, ? extends Hardware> apply(Set<? extends Hardware> from) {
                return Maps.uniqueIndex(from, (Function)new Function<Hardware, String>(){

                    public String apply(Hardware from) {
                        return from.getId();
                    }
                });
            }
        }, sizes);
    }

    @Provides
    @Singleton
    @Memoized
    protected Supplier<Set<? extends Hardware>> supplySizeCache(@Named(value="jclouds.session-interval") long seconds, final Supplier<Set<? extends Hardware>> hardwareSupplier) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Set<? extends Hardware>>(){

            public Set<? extends Hardware> get() {
                return (Set)hardwareSupplier.get();
            }
        });
    }

    @Provides
    @Singleton
    protected Function<ComputeMetadata, String> indexer() {
        return new Function<ComputeMetadata, String>(){

            public String apply(ComputeMetadata from) {
                return from.getProviderId();
            }
        };
    }

    @Singleton
    static class RunScriptOnNodeFactoryImpl
    implements RunScriptOnNode.Factory {
        private final Factory factory;

        @Inject
        RunScriptOnNodeFactoryImpl(Factory factory) {
            this.factory = (Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        }

        @Override
        public RunScriptOnNode create(NodeMetadata node, Statement runScript, RunScriptOptions options) {
            Preconditions.checkNotNull((Object)node, (Object)"node");
            Preconditions.checkNotNull((Object)runScript, (Object)"runScript");
            Preconditions.checkNotNull((Object)options, (Object)"options");
            return !options.shouldWrapInInitScript() ? this.factory.exec(node, runScript, options) : (options.shouldBlockOnComplete() ? this.factory.backgroundAndBlockOnComplete(node, runScript, options) : this.factory.background(node, runScript, options));
        }

        @Override
        public RunScriptOnNode create(NodeMetadata node, String script) {
            return this.create(node, Statements.exec((String)((String)Preconditions.checkNotNull((Object)script, (Object)"script"))));
        }

        @Override
        public RunScriptOnNode create(NodeMetadata node, Statement script) {
            return this.create(node, script, RunScriptOptions.NONE);
        }

        static interface Factory {
            @Named(value="direct")
            public RunScriptOnNode exec(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="blocking")
            public RunScriptOnNode backgroundAndBlockOnComplete(NodeMetadata var1, Statement var2, RunScriptOptions var3);

            @Named(value="nonblocking")
            public RunScriptOnNode background(NodeMetadata var1, Statement var2, RunScriptOptions var3);
        }
    }
}

