/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.internal.ComputeMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadataBuilder;

public class ComputeMetadataBuilder
extends ResourceMetadataBuilder<ComputeType> {
    protected String id;
    protected ComputeType type;

    public ComputeMetadataBuilder(ComputeType type) {
        this.type = (ComputeType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
    }

    public ComputeMetadataBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ComputeMetadataBuilder ids(String id) {
        this.id(id).providerId(id);
        return this;
    }

    public ComputeMetadataBuilder providerId(String providerId) {
        return (ComputeMetadataBuilder)((Object)ComputeMetadataBuilder.class.cast(super.providerId(providerId)));
    }

    public ComputeMetadataBuilder name(String name) {
        return (ComputeMetadataBuilder)((Object)ComputeMetadataBuilder.class.cast(super.name(name)));
    }

    public ComputeMetadataBuilder location(Location location) {
        return (ComputeMetadataBuilder)((Object)ComputeMetadataBuilder.class.cast(super.location(location)));
    }

    public ComputeMetadataBuilder uri(URI uri) {
        return (ComputeMetadataBuilder)((Object)ComputeMetadataBuilder.class.cast(super.uri(uri)));
    }

    public ComputeMetadataBuilder userMetadata(Map<String, String> userMetadata) {
        return (ComputeMetadataBuilder)((Object)ComputeMetadataBuilder.class.cast(super.userMetadata(userMetadata)));
    }

    public ComputeMetadata build() {
        return new ComputeMetadataImpl(this.type, this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata);
    }

    public static ComputeMetadataBuilder fromComputeMetadata(ComputeMetadata in) {
        return new ComputeMetadataBuilder(in.getType()).id(in.getId()).location(in.getLocation()).name(in.getName()).uri(in.getUri()).userMetadata(in.getUserMetadata());
    }
}

