/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.HardwareImpl;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;

public class HardwareBuilder
extends ComputeMetadataBuilder {
    private List<Processor> processors = Lists.newArrayList();
    private int ram;
    private List<Volume> volumes = Lists.newArrayList();
    private Predicate<Image> supportsImage = ImagePredicates.any();

    public HardwareBuilder() {
        super(ComputeType.HARDWARE);
    }

    public HardwareBuilder processors(List<Processor> processors) {
        this.processors = (List)Preconditions.checkNotNull(processors, (Object)"processors");
        return this;
    }

    public HardwareBuilder ram(int ram) {
        this.ram = ram;
        return this;
    }

    public HardwareBuilder volumes(List<Volume> volumes) {
        this.volumes = (List)Preconditions.checkNotNull(volumes, (Object)"volumes");
        return this;
    }

    public HardwareBuilder supportsImage(Predicate<Image> supportsImage) {
        this.supportsImage = (Predicate)Preconditions.checkNotNull(supportsImage, (Object)"supportsImage");
        return this;
    }

    public HardwareBuilder is64Bit(boolean is64Bit) {
        this.supportsImage((Predicate<Image>)(is64Bit ? ImagePredicates.is64Bit() : Predicates.not(ImagePredicates.is64Bit())));
        return this;
    }

    @Override
    public HardwareBuilder id(String id) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.id(id)));
    }

    @Override
    public HardwareBuilder ids(String id) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.ids(id)));
    }

    @Override
    public HardwareBuilder providerId(String providerId) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.providerId(providerId)));
    }

    @Override
    public HardwareBuilder name(String name) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.name(name)));
    }

    @Override
    public HardwareBuilder location(Location location) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.location(location)));
    }

    @Override
    public HardwareBuilder uri(URI uri) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast((Object)super.uri(uri)));
    }

    @Override
    public HardwareBuilder userMetadata(Map<String, String> userMetadata) {
        return (HardwareBuilder)((Object)HardwareBuilder.class.cast(super.userMetadata((Map)userMetadata)));
    }

    @Override
    public Hardware build() {
        return new HardwareImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.processors, this.ram, this.volumes, this.supportsImage);
    }

    public static HardwareBuilder fromHardware(Hardware in) {
        return ((HardwareBuilder)new HardwareBuilder().id(in.getId()).providerId(in.getProviderId()).location(in.getLocation()).name(in.getName()).uri(in.getUri()).userMetadata(in.getUserMetadata())).processors((List)List.class.cast(in.getProcessors())).ram(in.getRam()).volumes((List)List.class.cast(in.getVolumes())).supportsImage(in.supportsImage());
    }
}

