/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.NodeMetadataImpl;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;

public class NodeMetadataBuilder
extends ComputeMetadataBuilder {
    private NodeState state;
    private Set<String> publicAddresses = Sets.newLinkedHashSet();
    private Set<String> privateAddresses = Sets.newLinkedHashSet();
    @Nullable
    private String adminPassword;
    @Nullable
    private Credentials credentials;
    @Nullable
    private String group;
    private int loginPort = 22;
    @Nullable
    private String imageId;
    @Nullable
    private Hardware hardware;
    @Nullable
    private OperatingSystem os;

    public NodeMetadataBuilder() {
        super(ComputeType.NODE);
    }

    public NodeMetadataBuilder loginPort(int loginPort) {
        this.loginPort = loginPort;
        return this;
    }

    public NodeMetadataBuilder state(NodeState state) {
        this.state = (NodeState)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
        return this;
    }

    public NodeMetadataBuilder publicAddresses(Iterable<String> publicAddresses) {
        this.publicAddresses = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(publicAddresses, (Object)"publicAddresses")));
        return this;
    }

    public NodeMetadataBuilder privateAddresses(Iterable<String> privateAddresses) {
        this.privateAddresses = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(privateAddresses, (Object)"privateAddresses")));
        return this;
    }

    public NodeMetadataBuilder credentials(@Nullable Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public NodeMetadataBuilder adminPassword(@Nullable String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public NodeMetadataBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public NodeMetadataBuilder imageId(@Nullable String imageId) {
        this.imageId = imageId;
        return this;
    }

    public NodeMetadataBuilder hardware(@Nullable Hardware hardware) {
        this.hardware = hardware;
        return this;
    }

    public NodeMetadataBuilder operatingSystem(@Nullable OperatingSystem os) {
        this.os = os;
        return this;
    }

    @Override
    public NodeMetadataBuilder id(String id) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.id(id)));
    }

    @Override
    public NodeMetadataBuilder ids(String id) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.ids(id)));
    }

    @Override
    public NodeMetadataBuilder providerId(String providerId) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.providerId(providerId)));
    }

    @Override
    public NodeMetadataBuilder name(String name) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.name(name)));
    }

    @Override
    public NodeMetadataBuilder location(Location location) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.location(location)));
    }

    @Override
    public NodeMetadataBuilder uri(URI uri) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast((Object)super.uri(uri)));
    }

    @Override
    public NodeMetadataBuilder userMetadata(Map<String, String> userMetadata) {
        return (NodeMetadataBuilder)((Object)NodeMetadataBuilder.class.cast(super.userMetadata((Map)userMetadata)));
    }

    @Override
    public NodeMetadata build() {
        return new NodeMetadataImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.group, this.hardware, this.imageId, this.os, this.state, this.loginPort, this.publicAddresses, this.privateAddresses, this.adminPassword, this.credentials);
    }

    public static NodeMetadataBuilder fromNodeMetadata(NodeMetadata node) {
        return ((NodeMetadataBuilder)new NodeMetadataBuilder().providerId(node.getProviderId()).name(node.getName()).id(node.getId()).location(node.getLocation()).uri(node.getUri()).userMetadata(node.getUserMetadata())).group(node.getGroup()).hardware(node.getHardware()).imageId(node.getImageId()).operatingSystem(node.getOperatingSystem()).state(node.getState()).loginPort(node.getLoginPort()).publicAddresses(node.getPublicAddresses()).privateAddresses(node.getPrivateAddresses()).adminPassword(node.getAdminPassword()).credentials(node.getCredentials());
    }
}

