/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.OsFamily;

@Beta
public class OperatingSystem {
    @Nullable
    private OsFamily family;
    @Nullable
    private String name;
    @Nullable
    private String arch;
    @Nullable
    private String version;
    private String description;
    private boolean is64Bit;

    protected OperatingSystem() {
    }

    public OperatingSystem(@Nullable OsFamily family, @Nullable String name, @Nullable String version, @Nullable String arch, String description, boolean is64Bit) {
        this.family = family;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.is64Bit = is64Bit;
    }

    @Nullable
    public OsFamily getFamily() {
        return this.family;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getArch() {
        return this.arch;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arch == null ? 0 : this.arch.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.family == null ? 0 : this.family.hashCode());
        result = 31 * result + (this.is64Bit ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.arch == null ? other.arch != null : !this.arch.equals(other.arch)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.family == null ? other.family != null : !this.family.equals((Object)other.family)) {
            return false;
        }
        if (this.is64Bit != other.is64Bit) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "[name=" + this.name + ", family=" + (Object)((Object)this.family) + ", version=" + this.version + ", arch=" + this.arch + ", is64Bit=" + this.is64Bit + ", description=" + this.description + "]";
    }
}

