/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;

public class OperatingSystemBuilder {
    @Nullable
    private OsFamily family;
    @Nullable
    private String name;
    @Nullable
    private String arch;
    @Nullable
    private String version;
    private String description;
    private boolean is64Bit;

    public OperatingSystemBuilder family(@Nullable OsFamily family) {
        this.family = family;
        return this;
    }

    public OperatingSystemBuilder name(@Nullable String name) {
        this.name = name;
        return this;
    }

    public OperatingSystemBuilder arch(@Nullable String arch) {
        this.arch = arch;
        return this;
    }

    public OperatingSystemBuilder version(@Nullable String version) {
        this.version = version;
        return this;
    }

    public OperatingSystemBuilder description(String description) {
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        return this;
    }

    public OperatingSystemBuilder is64Bit(boolean is64Bit) {
        this.is64Bit = is64Bit;
        return this;
    }

    public OperatingSystem build() {
        return new OperatingSystem(this.family, this.name, this.version, this.arch, this.description, this.is64Bit);
    }

    public static OperatingSystem fromOperatingSystem(OperatingSystem in) {
        return new OperatingSystem(in.getFamily(), in.getName(), in.getVersion(), in.getArch(), in.getDescription(), in.is64Bit());
    }
}

