/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;

public class VolumeBuilder {
    private Volume.Type type;
    private String id;
    @Nullable
    private Float size;
    @Nullable
    private String device;
    private boolean bootDevice;
    private boolean durable;

    public VolumeBuilder type(Volume.Type type) {
        this.type = (Volume.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        return this;
    }

    public VolumeBuilder id(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        return this;
    }

    public VolumeBuilder size(@Nullable Float size) {
        this.size = size;
        return this;
    }

    public VolumeBuilder device(@Nullable String device) {
        this.device = device;
        return this;
    }

    public VolumeBuilder bootDevice(boolean bootDevice) {
        this.bootDevice = bootDevice;
        return this;
    }

    public VolumeBuilder durable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public Volume build() {
        return new VolumeImpl(this.id, this.type, this.size, this.device, this.bootDevice, this.durable);
    }

    public static Volume fromVolume(Volume in) {
        return new VolumeImpl(in.getId(), in.getType(), in.getSize(), in.getDevice(), in.isBootDevice(), in.isDurable());
    }
}

