/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.Volume;

public class VolumeImpl
implements Volume {
    private static final long serialVersionUID = -3306004212804159093L;
    private final String id;
    private final Volume.Type type;
    @Nullable
    private final Float size;
    @Nullable
    private final String device;
    private final boolean bootDevice;
    private final boolean durable;

    public VolumeImpl(@Nullable String id, Volume.Type type, @Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this.id = id;
        this.type = (Volume.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
        this.size = size;
        this.device = device;
        this.bootDevice = bootDevice;
        this.durable = durable;
    }

    public VolumeImpl(@Nullable Float size, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, null, bootDevice, durable);
    }

    public VolumeImpl(@Nullable Float size, @Nullable String device, boolean bootDevice, boolean durable) {
        this(null, Volume.Type.LOCAL, size, device, bootDevice, durable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Volume.Type getType() {
        return this.type;
    }

    @Override
    public Float getSize() {
        return this.size;
    }

    @Override
    public String getDevice() {
        return this.device;
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isBootDevice() {
        return this.bootDevice;
    }

    public String toString() {
        return "[id=" + this.getId() + ", type=" + (Object)((Object)this.type) + ", size=" + this.size + ", device=" + this.device + ", durable=" + this.durable + ", isBootDevice=" + this.bootDevice + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bootDevice ? 1231 : 1237);
        result = 31 * result + (this.device == null ? 0 : this.device.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VolumeImpl other = (VolumeImpl)obj;
        if (this.bootDevice != other.bootDevice) {
            return false;
        }
        if (this.device == null ? other.device != null : !this.device.equals(other.device)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }
}

