/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.os;

import com.google.common.annotations.Beta;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;

@Beta
public class CIMOperatingSystem
extends OperatingSystem {
    private OSType osType;

    protected CIMOperatingSystem() {
    }

    public CIMOperatingSystem(OSType osType, String version, String arch, String description) {
        super(osType.getFamily(), osType.getValue(), version, arch, description, osType.is64Bit());
        this.osType = osType;
    }

    public OSType getOsType() {
        return this.osType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.osType == null ? 0 : this.osType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIMOperatingSystem other = (CIMOperatingSystem)obj;
        return !(this.osType == null ? other.osType != null : !this.osType.equals((Object)other.osType));
    }

    @Override
    public String toString() {
        return "[osType=" + (Object)((Object)this.osType) + ", version=" + this.getVersion() + ", arch=" + this.getArch() + ", description=" + this.getDescription() + "]";
    }

    public static enum OSType {
        OTHER(1, "Other", OsFamily.UNRECOGNIZED, false),
        MACOS(2, "MACOS", OsFamily.DARWIN, false),
        SOLARIS(29, "Solaris", OsFamily.SOLARIS, false),
        LINUX(36, "LINUX", OsFamily.LINUX, false),
        FREEBSD(42, "FreeBSD", OsFamily.FREEBSD, false),
        NETBSD(43, "NetBSD", OsFamily.NETBSD, false),
        OPENBSD(65, "OpenBSD", OsFamily.OPENBSD, false),
        NOT_APPLICABLE(66, "Not Applicable", OsFamily.UNRECOGNIZED, false),
        WINDOWS_SERVER_2003(69, "Microsoft Windows Server 2003", OsFamily.WINDOWS, false),
        WINDOWS_SERVER_2003_64(70, "Microsoft Windows Server 2003 64-Bit", OsFamily.WINDOWS, true),
        WINDOWS_SERVER_2008(76, "Microsoft Windows Server 2008", OsFamily.WINDOWS, false),
        WINDOWS_SERVER_2008_64(77, "Microsoft Windows Server 2008 64-Bit", OsFamily.WINDOWS, true),
        FREEBSD_64(78, "FreeBSD 64-Bit", OsFamily.FREEBSD, true),
        RHEL(79, "RedHat Enterprise Linux", OsFamily.RHEL, false),
        RHEL_64(80, "RedHat Enterprise Linux 64-Bit", OsFamily.RHEL, true),
        SOLARIS_64(81, "Solaris 64-Bit", OsFamily.SOLARIS, true),
        SUSE(82, "SUSE", OsFamily.SUSE, false),
        SUSE_64(83, "SUSE 64-Bit", OsFamily.SUSE, true),
        SLES(84, "SLES", OsFamily.SUSE, false),
        SLES_64(85, "SLES 64-Bit", OsFamily.SUSE, true),
        NOVELL_OES(86, "Novell OES", OsFamily.SUSE, true),
        MANDRIVA(89, "Mandriva", OsFamily.MANDRIVA, false),
        MANDRIVA_64(90, "Mandriva 64-Bit", OsFamily.MANDRIVA, true),
        TURBOLINUX(91, "TurboLinux", OsFamily.TURBOLINUX, false),
        TURBOLINUX_64(92, "TurboLinux 64-Bit", OsFamily.TURBOLINUX, true),
        UBUNTU(93, "Ubuntu", OsFamily.UBUNTU, false),
        UBUNTU_64(94, "Ubuntu 64-Bit", OsFamily.UBUNTU, true),
        DEBIAN(95, "Debian", OsFamily.DEBIAN, false),
        DEBIAN_64(96, "Debian 64-Bit", OsFamily.DEBIAN, false),
        LINUX_2_4(97, "Linux 2.4.x", OsFamily.LINUX, false),
        LINUX_2_4_64(98, "Linux 2.4.x 64-Bit", OsFamily.LINUX, true),
        LINUX_2_6(99, "Linux 2.6.x", OsFamily.LINUX, false),
        LINUX_2_6_64(100, "Linux 2.6.x 64-Bit", OsFamily.LINUX, true),
        LINUX_64(101, "Linux 64-Bit", OsFamily.LINUX, true),
        OTHER_64(102, "Other 64-Bit", OsFamily.UNRECOGNIZED, true),
        WINDOWS_SERVER_2008_R2(103, "Microsoft Windows Server 2008 R2", OsFamily.WINDOWS, true),
        ESXI(104, "VMware ESXi", OsFamily.ESX, true),
        WINDOWS_7(105, "Microsoft Windows 7", OsFamily.WINDOWS, false),
        CENTOS(106, "CentOS 32-bit", OsFamily.CENTOS, false),
        CENTOS_64(107, "CentOS 64-bit", OsFamily.CENTOS, true),
        ORACLE_ENTERPRISE_LINUX(108, "Oracle Enterprise Linux 32-bit", OsFamily.OEL, false),
        ORACLE_ENTERPRISE_LINUX_64(109, "Oracle Enterprise Linux 64-bit", OsFamily.OEL, true),
        UNRECOGNIZED(Integer.MAX_VALUE, "UNRECOGNIZED", null, true);

        private final int code;
        private final String value;
        private final OsFamily family;
        private final boolean is64Bit;

        public int getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public OsFamily getFamily() {
            return this.family;
        }

        public boolean is64Bit() {
            return this.is64Bit;
        }

        private OSType(int code, String value, OsFamily family, boolean is64Bit) {
            this.code = code;
            this.value = value;
            this.family = family;
            this.is64Bit = is64Bit;
        }

        public static OSType fromValue(int code) {
            for (OSType type : OSType.values()) {
                if (type.code != code) continue;
                return type;
            }
            return UNRECOGNIZED;
        }
    }
}

