/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.RetryIfSocketNotYetOpen;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.net.IPSocket;
import org.jclouds.ssh.SshClient;

@Singleton
public class CreateSshClientOncePortIsListeningOnNode
implements Function<NodeMetadata, SshClient> {
    @Inject(optional=true)
    SshClient.Factory sshFactory;
    private final RetryIfSocketNotYetOpen socketTester;

    @Inject
    public CreateSshClientOncePortIsListeningOnNode(RetryIfSocketNotYetOpen socketTester) {
        this.socketTester = socketTester;
    }

    public SshClient apply(NodeMetadata node) {
        Preconditions.checkState((this.sshFactory != null ? 1 : 0) != 0, (Object)"ssh requested, but no SshModule configured");
        Preconditions.checkNotNull((Object)node.getCredentials(), (String)"no credentials found for node %s", (Object[])new Object[]{node.getId()});
        Preconditions.checkNotNull((Object)node.getCredentials().identity, (String)"no login identity found for node %s", (Object[])new Object[]{node.getId()});
        Preconditions.checkNotNull((Object)node.getCredentials().credential, (String)"no credential found for %s on node %s", (Object[])new Object[]{node.getCredentials().identity, node.getId()});
        IPSocket socket = ComputeServiceUtils.findReachableSocketOnNode(this.socketTester, node, node.getLoginPort());
        return this.sshFactory.create(socket, node.getCredentials());
    }
}

