/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.inject.Singleton;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.scriptbuilder.InitBuilder;
import org.jclouds.scriptbuilder.domain.AuthorizeRSAPublicKey;
import org.jclouds.scriptbuilder.domain.InstallRSAPrivateKey;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;

@Singleton
public class TemplateOptionsToStatement
implements Function<TemplateOptions, Statement> {
    public Statement apply(TemplateOptions options) {
        ArrayList bootstrap = Lists.newArrayList();
        if (options.getPublicKey() != null) {
            bootstrap.add(new AuthorizeRSAPublicKey(options.getPublicKey()));
        }
        if (options.getRunScript() != null) {
            bootstrap.add(options.getRunScript());
        }
        if (options.getPrivateKey() != null) {
            bootstrap.add(new InstallRSAPrivateKey(options.getPrivateKey()));
        }
        if (bootstrap.size() >= 1) {
            if (options.getTaskName() == null && !(options.getRunScript() instanceof InitBuilder)) {
                options.nameTask("bootstrap");
            }
            return bootstrap.size() == 1 ? (Statement)bootstrap.get(0) : new StatementList((Iterable)bootstrap);
        }
        return null;
    }
}

