/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.RunScriptOnNodesException;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.util.Strings2;

@Singleton
public class BaseComputeService
implements ComputeService {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ComputeServiceContext context;
    protected final Map<String, Credentials> credentialStore;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwareProfiles;
    private final Supplier<Set<? extends Location>> locations;
    private final ListNodesStrategy listNodesStrategy;
    private final GetNodeMetadataStrategy getNodeMetadataStrategy;
    private final CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy;
    private final RebootNodeStrategy rebootNodeStrategy;
    private final DestroyNodeStrategy destroyNodeStrategy;
    private final ResumeNodeStrategy resumeNodeStrategy;
    private final SuspendNodeStrategy suspendNodeStrategy;
    private final Provider<TemplateBuilder> templateBuilderProvider;
    private final Provider<TemplateOptions> templateOptionsProvider;
    private final Predicate<NodeMetadata> nodeRunning;
    private final Predicate<NodeMetadata> nodeTerminated;
    private final Predicate<NodeMetadata> nodeSuspended;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final ComputeServiceConstants.Timeouts timeouts;
    private final ExecutorService executor;

    @Inject
    protected BaseComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwareProfiles, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy resumeNodeStrategy, SuspendNodeStrategy suspendNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, Provider<TemplateOptions> templateOptionsProvider, @Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, @Named(value="NODE_TERMINATED") Predicate<NodeMetadata> nodeTerminated, @Named(value="NODE_SUSPENDED") Predicate<NodeMetadata> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.context = (ComputeServiceContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwareProfiles = (Supplier)Preconditions.checkNotNull(hardwareProfiles, (Object)"hardwareProfiles");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.listNodesStrategy = (ListNodesStrategy)Preconditions.checkNotNull((Object)listNodesStrategy, (Object)"listNodesStrategy");
        this.getNodeMetadataStrategy = (GetNodeMetadataStrategy)Preconditions.checkNotNull((Object)getNodeMetadataStrategy, (Object)"getNodeMetadataStrategy");
        this.runNodesAndAddToSetStrategy = (CreateNodesInGroupThenAddToSet)Preconditions.checkNotNull((Object)runNodesAndAddToSetStrategy, (Object)"runNodesAndAddToSetStrategy");
        this.rebootNodeStrategy = (RebootNodeStrategy)Preconditions.checkNotNull((Object)rebootNodeStrategy, (Object)"rebootNodeStrategy");
        this.resumeNodeStrategy = (ResumeNodeStrategy)Preconditions.checkNotNull((Object)resumeNodeStrategy, (Object)"resumeNodeStrategy");
        this.suspendNodeStrategy = (SuspendNodeStrategy)Preconditions.checkNotNull((Object)suspendNodeStrategy, (Object)"suspendNodeStrategy");
        this.destroyNodeStrategy = (DestroyNodeStrategy)Preconditions.checkNotNull((Object)destroyNodeStrategy, (Object)"destroyNodeStrategy");
        this.templateBuilderProvider = (Provider)Preconditions.checkNotNull(templateBuilderProvider, (Object)"templateBuilderProvider");
        this.templateOptionsProvider = (Provider)Preconditions.checkNotNull(templateOptionsProvider, (Object)"templateOptionsProvider");
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.nodeTerminated = (Predicate)Preconditions.checkNotNull(nodeTerminated, (Object)"nodeTerminated");
        this.nodeSuspended = (Predicate)Preconditions.checkNotNull(nodeSuspended, (Object)"nodeSuspended");
        this.initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)Preconditions.checkNotNull((Object)initScriptRunnerFactory, (Object)"initScriptRunnerFactory");
        this.timeouts = (ComputeServiceConstants.Timeouts)Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public ComputeServiceContext getContext() {
        return this.context;
    }

    @Override
    public Set<? extends NodeMetadata> runNodesWithTag(String group, int count, Template template) throws RunNodesException {
        return this.createNodesInGroup(group, count, template);
    }

    @Override
    public Set<? extends NodeMetadata> runNodesWithTag(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateBuilder().any().options(templateOptions).build());
    }

    @Override
    public Set<? extends NodeMetadata> runNodesWithTag(String group, int count) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateOptions());
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, Template template) throws RunNodesException {
        Preconditions.checkNotNull((Object)group, (Object)"group cannot be null");
        Preconditions.checkNotNull((Object)template.getLocation(), (Object)"location");
        this.logger.debug(">> running %d node%s group(%s) location(%s) image(%s) hardwareProfile(%s) options(%s)", new Object[]{count, count > 1 ? "s" : "", group, template.getLocation().getId(), template.getImage().getId(), template.getHardware().getId(), template.getOptions()});
        LinkedHashSet goodNodes = Sets.newLinkedHashSet();
        LinkedHashMap badNodes = Maps.newLinkedHashMap();
        LinkedHashMultimap customizationResponses = LinkedHashMultimap.create();
        Map<?, Future<Void>> responses = this.runNodesAndAddToSetStrategy.execute(group, count, template, goodNodes, badNodes, (Multimap<NodeMetadata, CustomizationResponse>)customizationResponses);
        Map executionExceptions = FutureIterables.awaitCompletion(responses, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("runNodesWithTag(" + group + ")"));
        for (NodeMetadata node : Iterables.concat((Iterable)goodNodes, badNodes.keySet())) {
            if (node.getCredentials() == null) continue;
            this.credentialStore.put("node#" + node.getId(), node.getCredentials());
        }
        if (executionExceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunNodesException(group, count, template, goodNodes, executionExceptions, badNodes);
        }
        return goodNodes;
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count, TemplateOptions templateOptions) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateBuilder().any().options(templateOptions).build());
    }

    @Override
    public Set<? extends NodeMetadata> createNodesInGroup(String group, int count) throws RunNodesException {
        return this.createNodesInGroup(group, count, this.templateOptions());
    }

    @Override
    public void destroyNode(final String id) {
        boolean successful;
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> destroying node(%s)", new Object[]{id});
        final AtomicReference node = new AtomicReference();
        RetryablePredicate tester = new RetryablePredicate((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    NodeMetadata md = BaseComputeService.this.destroyNodeStrategy.destroyNode(id);
                    if (md != null) {
                        node.set(md);
                    }
                    return true;
                }
                catch (IllegalStateException e) {
                    BaseComputeService.this.logger.warn("<< illegal state destroying node(%s)", new Object[]{id});
                    return false;
                }
            }
        }, this.timeouts.nodeRunning, 1000L, TimeUnit.MILLISECONDS);
        boolean bl = successful = tester.apply((Object)id) && (node.get() == null || this.nodeTerminated.apply(node.get()));
        if (successful) {
            this.credentialStore.remove("node#" + id);
        }
        this.logger.debug("<< destroyed node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public Set<? extends NodeMetadata> destroyNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> destroying nodes matching(%s)", new Object[]{filter});
        LinkedHashSet set = Sets.newLinkedHashSet((Iterable)FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminated(filter), (Function)new Function<NodeMetadata, Future<NodeMetadata>>(){

            public Future<NodeMetadata> apply(final NodeMetadata from) {
                return BaseComputeService.this.executor.submit(new Callable<NodeMetadata>(){

                    @Override
                    public NodeMetadata call() throws Exception {
                        BaseComputeService.this.destroyNode(from.getId());
                        return from;
                    }
                });
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("destroyNodesMatching(" + filter + ")")));
        this.logger.debug("<< destroyed(%d)", new Object[]{set.size()});
        return set;
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminated(Predicate<NodeMetadata> filter) {
        return Sets.filter(this.detailsOnAllNodes(), (Predicate)Predicates.and((Predicate)((Predicate)Preconditions.checkNotNull(filter, (Object)"filter")), (Predicate)Predicates.not(NodePredicates.TERMINATED)));
    }

    Iterable<? extends NodeMetadata> nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(Predicate<NodeMetadata> filter) {
        Iterable<? extends NodeMetadata> nodes = this.nodesMatchingFilterAndNotTerminated(filter);
        if (Iterables.size(nodes) == 0) {
            throw new NoSuchElementException("no nodes matched filter: " + filter);
        }
        return nodes;
    }

    public Set<ComputeMetadata> listNodes() {
        this.logger.debug(">> listing nodes", new Object[0]);
        LinkedHashSet set = Sets.newLinkedHashSet(this.listNodesStrategy.listNodes());
        this.logger.debug("<< list(%d)", new Object[]{set.size()});
        return set;
    }

    @Override
    public Set<? extends NodeMetadata> listNodesDetailsMatching(Predicate<ComputeMetadata> filter) {
        Preconditions.checkNotNull(filter, (Object)"filter");
        this.logger.debug(">> listing node details matching(%s)", new Object[]{filter});
        LinkedHashSet set = Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(filter));
        this.logger.debug("<< list(%d)", new Object[]{set.size()});
        return set;
    }

    @Override
    public Set<? extends Hardware> listHardwareProfiles() {
        return (Set)this.hardwareProfiles.get();
    }

    @Override
    public Set<? extends Image> listImages() {
        return (Set)this.images.get();
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    @Override
    public TemplateBuilder templateBuilder() {
        return (TemplateBuilder)this.templateBuilderProvider.get();
    }

    @Override
    public NodeMetadata getNodeMetadata(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return this.getNodeMetadataStrategy.getNode(id);
    }

    @Override
    public void rebootNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> rebooting node(%s)", new Object[]{id});
        NodeMetadata node = this.rebootNodeStrategy.rebootNode(id);
        boolean successful = this.nodeRunning.apply((Object)node);
        this.logger.debug("<< rebooted node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void rebootNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> rebooting nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.rebootNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("rebootNodesMatching(" + filter + ")"));
        this.logger.debug("<< rebooted", new Object[0]);
    }

    @Override
    public void resumeNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> resuming node(%s)", new Object[]{id});
        NodeMetadata node = this.resumeNodeStrategy.resumeNode(id);
        boolean successful = this.nodeRunning.apply((Object)node);
        this.logger.debug("<< resumed node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void resumeNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> resuming nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.resumeNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("resumeNodesMatching(" + filter + ")"));
        this.logger.debug("<< resumed", new Object[0]);
    }

    @Override
    public void suspendNode(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        this.logger.debug(">> suspending node(%s)", new Object[]{id});
        NodeMetadata node = this.suspendNodeStrategy.suspendNode(id);
        boolean successful = this.nodeSuspended.apply((Object)node);
        this.logger.debug("<< suspended node(%s) success(%s)", new Object[]{id, successful});
    }

    @Override
    public void suspendNodesMatching(Predicate<NodeMetadata> filter) {
        this.logger.debug(">> suspending nodes matching(%s)", new Object[]{filter});
        FutureIterables.transformParallel(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), (Function)new Function<NodeMetadata, Future<Void>>(){

            public Future<Void> apply(NodeMetadata from) {
                BaseComputeService.this.suspendNode(from.getId());
                return Futures.immediateFuture(null);
            }
        }, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("suspendNodesMatching(" + filter + ")"));
        this.logger.debug("<< suspended", new Object[0]);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Payload runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, runScript, RunScriptOptions.NONE);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Payload runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        try {
            return this.runScriptOnNodesMatching(filter, Statements.exec((String)Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)runScript, (Object)"runScript")).getInput())), options);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec((String)((String)Preconditions.checkNotNull((Object)runScript, (Object)"runScript"))));
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, runScript, RunScriptOptions.NONE);
    }

    @Override
    public Map<? extends NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, String runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        return this.runScriptOnNodesMatching(filter, Statements.exec((String)((String)Preconditions.checkNotNull((Object)runScript, (Object)"runScript"))), RunScriptOptions.NONE);
    }

    public Map<NodeMetadata, ExecResponse> runScriptOnNodesMatching(Predicate<NodeMetadata> filter, Statement runScript, RunScriptOptions options) throws RunScriptOnNodesException {
        Preconditions.checkNotNull(filter, (Object)"filter");
        Preconditions.checkNotNull((Object)runScript, (Object)"runScript");
        Preconditions.checkNotNull((Object)options, (Object)"options");
        LinkedHashMap goodNodes = Maps.newLinkedHashMap();
        LinkedHashMap badNodes = Maps.newLinkedHashMap();
        LinkedHashMap responses = Maps.newLinkedHashMap();
        Object exceptions = ImmutableMap.of();
        Iterable<? extends RunScriptOnNode> scriptRunners = this.transformNodesIntoInitializedScriptRunners(this.nodesMatchingFilterAndNotTerminatedExceptionIfNotFound(filter), runScript, options, badNodes);
        if (Iterables.size(scriptRunners) > 0) {
            for (RunScriptOnNode runScriptOnNode : scriptRunners) {
                responses.put(runScriptOnNode.getNode(), this.executor.submit(new RunScriptOnNodeAndAddToGoodMapOrPutExceptionIntoBadMap(runScriptOnNode, goodNodes, badNodes)));
            }
            exceptions = FutureIterables.awaitCompletion((Map)responses, (ExecutorService)this.executor, null, (Logger)this.logger, (String)("runScriptOnNodesMatching(" + filter + ")"));
        }
        if (exceptions.size() > 0 || badNodes.size() > 0) {
            throw new RunScriptOnNodesException(runScript, options, goodNodes, (Map<?, Exception>)exceptions, badNodes);
        }
        return goodNodes;
    }

    private Iterable<? extends RunScriptOnNode> transformNodesIntoInitializedScriptRunners(Iterable<? extends NodeMetadata> nodes, Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
        return Iterables.filter((Iterable)FutureIterables.transformParallel(nodes, (Function)new TransformNodesIntoInitializedScriptRunners(script, options, badNodes), (ExecutorService)this.executor, null, (Logger)this.logger, (String)"initialize script runners"), (Predicate)Predicates.notNull());
    }

    private Set<? extends NodeMetadata> detailsOnAllNodes() {
        return Sets.newLinkedHashSet(this.listNodesStrategy.listDetailsOnNodesMatching(NodePredicates.all()));
    }

    @Override
    public TemplateOptions templateOptions() {
        return (TemplateOptions)this.templateOptionsProvider.get();
    }

    private final class TransformNodesIntoInitializedScriptRunners
    implements Function<NodeMetadata, Future<RunScriptOnNode>> {
        private final Map<NodeMetadata, Exception> badNodes;
        private final Statement script;
        private final RunScriptOptions options;

        private TransformNodesIntoInitializedScriptRunners(Statement script, RunScriptOptions options, Map<NodeMetadata, Exception> badNodes) {
            this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
            this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
            this.options = (RunScriptOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        }

        public Future<RunScriptOnNode> apply(NodeMetadata node) {
            Preconditions.checkNotNull((Object)node, (Object)"node");
            if (this.options.getOverrideCredentials() != null) {
                node = NodeMetadataBuilder.fromNodeMetadata(node).credentials(this.options.getOverrideCredentials()).build();
            }
            return BaseComputeService.this.executor.submit(BaseComputeService.this.initScriptRunnerFactory.create(node, this.script, this.options, this.badNodes));
        }
    }
}

