/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.io.Payload;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.util.Strings2;

public class TemplateOptions
extends RunScriptOptions {
    public static final TemplateOptions NONE = new ImmutableTemplateOptions(new TemplateOptions());
    protected int[] inboundPorts = new int[]{22};
    protected Statement script;
    protected String privateKey;
    protected String publicKey;
    protected boolean includeMetadata;
    protected boolean blockUntilRunning = true;

    public int[] getInboundPorts() {
        return this.inboundPorts;
    }

    public Statement getRunScript() {
        return this.script;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public boolean shouldBlockUntilRunning() {
        return this.blockUntilRunning;
    }

    public <T extends TemplateOptions> T as(Class<T> clazz) {
        return (T)((TemplateOptions)clazz.cast(this));
    }

    @Deprecated
    public TemplateOptions runScript(byte[] script) {
        return this.runScript(Statements.exec((String)new String((byte[])Preconditions.checkNotNull((Object)script, (Object)"script"))));
    }

    public TemplateOptions runScript(Payload script) {
        try {
            return this.runScript(Statements.exec((String)Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)script, (Object)"script")).getInput())));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions runScript(Statement script) {
        this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
        return this;
    }

    public TemplateOptions installPrivateKey(String privateKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey")).startsWith("-----BEGIN RSA PRIVATE KEY-----"), (Object)"key should start with -----BEGIN RSA PRIVATE KEY-----");
        this.privateKey = privateKey;
        return this;
    }

    @Deprecated
    public TemplateOptions installPrivateKey(Payload privateKey) {
        try {
            return this.installPrivateKey(Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)privateKey, (Object)"privateKey")).getInput()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions dontAuthorizePublicKey() {
        this.publicKey = null;
        return this;
    }

    public TemplateOptions authorizePublicKey(String publicKey) {
        Preconditions.checkArgument((boolean)((String)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey")).startsWith("ssh-rsa"), (Object)"key should start with ssh-rsa");
        this.publicKey = publicKey;
        return this;
    }

    @Deprecated
    public TemplateOptions authorizePublicKey(Payload publicKey) {
        try {
            return this.authorizePublicKey(Strings2.toStringAndClose((InputStream)((Payload)Preconditions.checkNotNull((Object)publicKey, (Object)"publicKey")).getInput()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return this;
        }
    }

    public TemplateOptions inboundPorts(int ... ports) {
        for (int port : ports) {
            Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (Object)"port must be a positive integer < 65535");
        }
        this.inboundPorts = ports;
        return this;
    }

    public TemplateOptions withMetadata() {
        this.includeMetadata = true;
        return this;
    }

    @Override
    public String toString() {
        return "[inboundPorts=" + Arrays.toString(this.inboundPorts) + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", blockUntilRunning=" + this.blockUntilRunning + ", blockOnComplete=" + this.blockOnComplete + ", port:seconds=" + this.port + ":" + this.seconds + ", metadata/details: " + this.includeMetadata + "]";
    }

    public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        this.blockUntilRunning = blockUntilRunning;
        if (!blockUntilRunning) {
            this.seconds = -1;
            this.port = -1;
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blockUntilRunning ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.inboundPorts);
        result = 31 * result + (this.includeMetadata ? 1231 : 1237);
        result = 31 * result + this.port;
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + this.seconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateOptions other = (TemplateOptions)obj;
        if (this.blockUntilRunning != other.blockUntilRunning) {
            return false;
        }
        if (!Arrays.equals(this.inboundPorts, other.inboundPorts)) {
            return false;
        }
        if (this.includeMetadata != other.includeMetadata) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return this.seconds == other.seconds;
    }

    @Override
    public TemplateOptions blockOnPort(int port, int seconds) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    @Override
    public TemplateOptions nameTask(String name) {
        return (TemplateOptions)TemplateOptions.class.cast(super.nameTask(name));
    }

    @Override
    public TemplateOptions runAsRoot(boolean runAsRoot) {
        return (TemplateOptions)TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    @Override
    public TemplateOptions withOverridingCredentials(Credentials overridingCredentials) {
        return (TemplateOptions)TemplateOptions.class.cast(super.withOverridingCredentials(overridingCredentials));
    }

    @Override
    public TemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (TemplateOptions)TemplateOptions.class.cast(super.blockOnComplete(blockOnComplete));
    }

    public static class Builder
    extends RunScriptOptions.Builder {
        public static TemplateOptions nameTask(String name) {
            TemplateOptions options = new TemplateOptions();
            return options.nameTask(name);
        }

        public static TemplateOptions overrideCredentialsWith(Credentials credentials) {
            TemplateOptions options = new TemplateOptions();
            return options.withOverridingCredentials(credentials);
        }

        public static TemplateOptions runAsRoot(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.runAsRoot(value);
        }

        public static TemplateOptions blockOnPort(int port, int seconds) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static TemplateOptions inboundPorts(int ... ports) {
            TemplateOptions options = new TemplateOptions();
            return options.inboundPorts(ports);
        }

        public static TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            TemplateOptions options = new TemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        @Deprecated
        public static TemplateOptions runScript(byte[] script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions runScript(Payload script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        public static TemplateOptions runScript(Statement script) {
            TemplateOptions options = new TemplateOptions();
            return options.runScript(script);
        }

        @Deprecated
        public static TemplateOptions installPrivateKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static TemplateOptions installPrivateKey(Payload rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        @Deprecated
        public static TemplateOptions authorizePublicKey(String rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static TemplateOptions authorizePublicKey(Payload rsaKey) {
            TemplateOptions options = new TemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static TemplateOptions withDetails() {
            TemplateOptions options = new TemplateOptions();
            return options.withMetadata();
        }

        public static TemplateOptions blockOnComplete(boolean value) {
            TemplateOptions options = new TemplateOptions();
            return options.blockOnComplete(value);
        }
    }

    public static class ImmutableTemplateOptions
    extends TemplateOptions {
        private final TemplateOptions delegate;

        public ImmutableTemplateOptions(TemplateOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public <T extends TemplateOptions> T as(Class<T> clazz) {
            return this.delegate.as(clazz);
        }

        @Override
        public TemplateOptions authorizePublicKey(String publicKey) {
            throw new IllegalArgumentException("authorizePublicKey is immutable");
        }

        @Override
        public TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            throw new IllegalArgumentException("blockUntilRunning is immutable");
        }

        @Override
        public int[] getInboundPorts() {
            return this.delegate.getInboundPorts();
        }

        @Override
        public String getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPublicKey() {
            return this.delegate.getPublicKey();
        }

        @Override
        public Statement getRunScript() {
            return this.delegate.getRunScript();
        }

        @Override
        public boolean shouldBlockUntilRunning() {
            return this.delegate.shouldBlockUntilRunning();
        }

        @Override
        public TemplateOptions inboundPorts(int ... ports) {
            throw new IllegalArgumentException("ports is immutable");
        }

        @Override
        public TemplateOptions installPrivateKey(String privateKey) {
            throw new IllegalArgumentException("privateKey is immutable");
        }

        @Override
        public boolean isIncludeMetadata() {
            return this.delegate.isIncludeMetadata();
        }

        @Override
        public TemplateOptions runScript(byte[] script) {
            throw new IllegalArgumentException("withMetadata is immutable");
        }

        @Override
        public TemplateOptions withMetadata() {
            throw new IllegalArgumentException("withMetadata is immutable");
        }
    }
}

