/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.jclouds.compute.domain.Image;

public class ImagePredicates {
    public static Predicate<Image> idIn(Iterable<String> ids) {
        Preconditions.checkNotNull(ids, (Object)"ids must be defined");
        final HashSet search = Sets.newHashSet(ids);
        return new Predicate<Image>(){

            public boolean apply(Image image) {
                return search.contains(image.getId());
            }

            public String toString() {
                return "idIn(" + search + ")";
            }
        };
    }

    public static Predicate<Image> idEquals(final String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must be defined");
        return new Predicate<Image>(){

            public boolean apply(Image image) {
                return id.equals(image.getId());
            }

            public String toString() {
                return "idEquals(" + id + ")";
            }
        };
    }

    public static Predicate<Image> is64Bit() {
        return new Is64BitPredicate();
    }

    public static Predicate<Image> any() {
        return Predicates.alwaysTrue();
    }

    private static final class Is64BitPredicate
    implements Predicate<Image> {
        private Is64BitPredicate() {
        }

        public boolean apply(Image image) {
            return image.getOperatingSystem().is64Bit();
        }

        public String toString() {
            return "is64Bit()";
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Is64BitPredicate;
        }
    }
}

