/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.util.Preconditions2;

public class NodePredicates {
    public static final Predicate<NodeMetadata> RUNNING = new Predicate<NodeMetadata>(){

        public boolean apply(NodeMetadata nodeMetadata) {
            return nodeMetadata.getState() == NodeState.RUNNING;
        }

        public String toString() {
            return "RUNNING";
        }
    };
    public static final Predicate<NodeMetadata> TERMINATED = new Predicate<NodeMetadata>(){

        public boolean apply(NodeMetadata nodeMetadata) {
            return nodeMetadata.getState() == NodeState.TERMINATED;
        }

        public String toString() {
            return "TERMINATED";
        }
    };

    public static Predicate<ComputeMetadata> locationId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must be defined");
        return new LocationId(id);
    }

    public static Predicate<ComputeMetadata> parentLocationId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id must be defined");
        return new ParentLocationId(id);
    }

    public static Predicate<ComputeMetadata> withIds(String ... ids) {
        Preconditions.checkNotNull((Object)ids, (Object)"ids must be defined");
        final HashSet search = Sets.newHashSet((Object[])ids);
        return new Predicate<ComputeMetadata>(){

            public boolean apply(ComputeMetadata nodeMetadata) {
                return search.contains(nodeMetadata.getProviderId());
            }

            public String toString() {
                return "withIds(" + search + ")";
            }
        };
    }

    public static Predicate<ComputeMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<NodeMetadata> inGroup(final String group) {
        Preconditions2.checkNotEmpty((String)group, (String)"group must be defined");
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                return group.equals(nodeMetadata.getGroup());
            }

            public String toString() {
                return "inGroup(" + group + ")";
            }
        };
    }

    @Deprecated
    public static Predicate<NodeMetadata> withTag(String tag) {
        return NodePredicates.inGroup(tag);
    }

    public static Predicate<NodeMetadata> runningInGroup(final String group) {
        Preconditions2.checkNotEmpty((String)group, (String)"Tag must be defined");
        return new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata nodeMetadata) {
                return group.equals(nodeMetadata.getGroup()) && nodeMetadata.getState() == NodeState.RUNNING;
            }

            public String toString() {
                return "runningInGroup(" + group + ")";
            }
        };
    }

    @Deprecated
    public static Predicate<NodeMetadata> runningWithTag(String tag) {
        return NodePredicates.runningInGroup(tag);
    }

    private static class LocationId
    implements Predicate<ComputeMetadata> {
        private final String id;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocationId other = (LocationId)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        private LocationId(String id) {
            this.id = id;
        }

        public boolean apply(ComputeMetadata nodeMetadata) {
            return this.id.equals(nodeMetadata.getLocation().getId());
        }

        public String toString() {
            return "locationId(" + this.id + ")";
        }
    }

    private static class ParentLocationId
    implements Predicate<ComputeMetadata> {
        private final String id;

        private ParentLocationId(String id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParentLocationId other = (ParentLocationId)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public boolean apply(ComputeMetadata nodeMetadata) {
            if (nodeMetadata.getLocation().getParent() == null) {
                return false;
            }
            return this.id.equals(nodeMetadata.getLocation().getParent().getId());
        }

        public String toString() {
            return "ParentLocationId [id=" + this.id + "]";
        }
    }
}

