/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.logging.Logger;

@Singleton
public class NodePresentAndInIntendedState
implements Predicate<NodeMetadata> {
    private final ComputeService client;
    private final NodeState intended;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public NodePresentAndInIntendedState(NodeState intended, ComputeService client) {
        this.intended = intended;
        this.client = client;
    }

    public boolean apply(NodeMetadata node) {
        this.logger.trace("looking for state on node %s", new Object[]{Preconditions.checkNotNull((Object)node, (Object)"node")});
        node = this.refresh(node);
        if (node == null) {
            return false;
        }
        this.logger.trace("%s: looking for node state %s: currently: %s", new Object[]{node.getId(), this.intended, node.getState()});
        if (node.getState() == NodeState.ERROR) {
            throw new IllegalStateException("node " + node.getId() + " in location " + node.getLocation() + " is in error state");
        }
        return node.getState() == this.intended;
    }

    private NodeMetadata refresh(NodeMetadata node) {
        return this.client.getNodeMetadata(node.getId());
    }
}

