/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.predicates;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.logging.Logger;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.predicates.SocketOpen;

public class RetryIfSocketNotYetOpen
implements Predicate<IPSocket> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final SocketOpen socketTester;
    private long seconds;

    public RetryIfSocketNotYetOpen seconds(long seconds) {
        this.seconds = seconds;
        return this;
    }

    @Inject
    public RetryIfSocketNotYetOpen(SocketOpen socketTester, ComputeServiceConstants.Timeouts timeouts) {
        this.socketTester = socketTester;
        this.seconds = timeouts.portOpen;
    }

    public RetryIfSocketNotYetOpen(SocketOpen socketTester, Logger logger, long seconds) {
        this.socketTester = socketTester;
        this.logger = logger;
        this.seconds = seconds;
    }

    public String toString() {
        return "retryIfSocketNotYetOpen(" + this.seconds + ")";
    }

    public boolean apply(IPSocket socket) {
        this.logger.debug(">> blocking on socket %s for %d seconds", new Object[]{socket, this.seconds});
        RetryablePredicate tester = new RetryablePredicate((Predicate)this.socketTester, this.seconds, 1L, TimeUnit.SECONDS);
        boolean passed = tester.apply((Object)socket);
        if (passed) {
            this.logger.debug("<< socket %s opened", new Object[]{socket});
        } else {
            this.logger.warn("<< socket %s didn't open after %d seconds", new Object[]{socket, this.seconds});
        }
        return passed;
    }
}

