/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.RetryIfSocketNotYetOpen;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;

public class CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap
implements Callable<Void>,
Function<NodeMetadata, Void> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Predicate<NodeMetadata> nodeRunning;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final GetNodeMetadataStrategy getNode;
    private final RetryIfSocketNotYetOpen socketTester;
    private final ComputeServiceConstants.Timeouts timeouts;
    @Nullable
    private final Statement statement;
    private final TemplateOptions options;
    private NodeMetadata node;
    private final Set<NodeMetadata> goodNodes;
    private final Map<NodeMetadata, Exception> badNodes;
    private final Multimap<NodeMetadata, CustomizationResponse> customizationResponses;
    private transient boolean tainted;

    @AssistedInject
    public CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap(@Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, GetNodeMetadataStrategy getNode, RetryIfSocketNotYetOpen socketTester, ComputeServiceConstants.Timeouts timeouts, Function<TemplateOptions, Statement> templateOptionsToStatement, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, @Assisted TemplateOptions options, @Assisted @Nullable NodeMetadata node, @Assisted Set<NodeMetadata> goodNodes, @Assisted Map<NodeMetadata, Exception> badNodes, @Assisted Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        this.statement = (Statement)((Function)Preconditions.checkNotNull(templateOptionsToStatement, (Object)"templateOptionsToStatement")).apply(Preconditions.checkNotNull((Object)options, (Object)"options"));
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)Preconditions.checkNotNull((Object)initScriptRunnerFactory, (Object)"initScriptRunnerFactory");
        this.getNode = (GetNodeMetadataStrategy)Preconditions.checkNotNull((Object)getNode, (Object)"getNode");
        this.socketTester = (RetryIfSocketNotYetOpen)Preconditions.checkNotNull((Object)socketTester, (Object)"socketTester");
        this.timeouts = (ComputeServiceConstants.Timeouts)Preconditions.checkNotNull((Object)timeouts, (Object)"timeouts");
        this.node = node;
        this.options = (TemplateOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        this.goodNodes = (Set)Preconditions.checkNotNull(goodNodes, (Object)"goodNodes");
        this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
        this.customizationResponses = (Multimap)Preconditions.checkNotNull(customizationResponses, (Object)"customizationResponses");
    }

    @AssistedInject
    public CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap(@Named(value="NODE_RUNNING") Predicate<NodeMetadata> nodeRunning, GetNodeMetadataStrategy getNode, RetryIfSocketNotYetOpen socketTester, ComputeServiceConstants.Timeouts timeouts, Function<TemplateOptions, Statement> templateOptionsToStatement, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, @Assisted TemplateOptions options, @Assisted Set<NodeMetadata> goodNodes, @Assisted Map<NodeMetadata, Exception> badNodes, @Assisted Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        this(nodeRunning, getNode, socketTester, timeouts, templateOptionsToStatement, initScriptRunnerFactory, options, null, goodNodes, badNodes, customizationResponses);
    }

    @Override
    public Void call() {
        Preconditions.checkState((!this.tainted ? 1 : 0) != 0, (String)"this object is not designed to be reused: %s", (Object[])new Object[]{this.toString()});
        this.tainted = true;
        try {
            if (this.options.shouldBlockUntilRunning()) {
                RunScriptOnNode runner;
                if (!this.nodeRunning.apply((Object)this.node)) {
                    throw new IllegalStateException(String.format("node didn't achieve the state running on node %s within %d seconds, final state: %s", new Object[]{this.node.getId(), this.timeouts.nodeRunning / 1000L, this.node.getState()}));
                }
                this.node = this.getNode.getNode(this.node.getId());
                if (this.statement != null && (runner = this.initScriptRunnerFactory.create(this.node, this.statement, this.options, this.badNodes).call()) != null) {
                    ExecResponse exec = runner.call();
                    this.customizationResponses.put((Object)this.node, (Object)exec);
                }
                if (this.options.getPort() > 0) {
                    ComputeServiceUtils.findReachableSocketOnNode(this.socketTester.seconds(this.options.getSeconds()), this.node, this.options.getPort());
                }
            }
            this.logger.debug("<< options applied node(%s)", new Object[]{this.node.getId()});
            this.goodNodes.add(this.node);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "<< problem applying options to node(%s): ", new Object[]{this.node.getId(), Throwables.getRootCause((Throwable)e).getMessage()});
            this.badNodes.put(this.node, e);
        }
        return null;
    }

    public Void apply(NodeMetadata input) {
        this.node = input;
        this.call();
        return null;
    }

    public static interface Factory {
        public Callable<Void> create(TemplateOptions var1, NodeMetadata var2, Set<NodeMetadata> var3, Map<NodeMetadata, Exception> var4, Multimap<NodeMetadata, CustomizationResponse> var5);

        public Function<NodeMetadata, Void> create(TemplateOptions var1, Set<NodeMetadata> var2, Map<NodeMetadata, Exception> var3, Multimap<NodeMetadata, CustomizationResponse> var4);
    }
}

