/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.concurrent.Futures;
import org.jclouds.logging.Logger;

@Singleton
public class CreateNodesWithGroupEncodedIntoNameThenAddToSet
implements CreateNodesInGroupThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy;
    protected final ListNodesStrategy listNodesStrategy;
    protected final String nodeNamingConvention;
    protected final ExecutorService executor;
    protected final CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;

    @Inject
    protected CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, @Named(value="NAMING_CONVENTION") String nodeNamingConvention, @Named(value="jclouds.user-threads") ExecutorService executor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory) {
        this.addNodeWithTagStrategy = addNodeWithTagStrategy;
        this.listNodesStrategy = listNodesStrategy;
        this.nodeNamingConvention = nodeNamingConvention;
        this.executor = executor;
        this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory = customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
    }

    @Override
    public Map<?, Future<Void>> execute(String tag, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (String name : this.getNextNames(tag, template, count)) {
            responses.put(name, Futures.compose(this.executor.submit(new AddNode(name, tag, template)), this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory.create(template.getOptions(), goodNodes, badNodes, customizationResponses), (ExecutorService)this.executor));
        }
        return responses;
    }

    protected Set<String> getNextNames(String tag, Template template, int count) {
        LinkedHashSet names = Sets.newLinkedHashSet();
        Iterable<? extends ComputeMetadata> currentNodes = this.listNodesStrategy.listNodes();
        int maxTries = 100;
        int currentTries = 0;
        while (names.size() < count && currentTries++ < maxTries) {
            final String name = this.getNextName(tag, template);
            if (Iterables.any(currentNodes, (Predicate)new Predicate<ComputeMetadata>(){

                public boolean apply(ComputeMetadata input) {
                    return name.equals(input.getName());
                }
            })) continue;
            names.add(name);
        }
        return names;
    }

    protected String getNextName(String tag, Template template) {
        return String.format(this.nodeNamingConvention, tag, Integer.toHexString(new SecureRandom().nextInt(4095)));
    }

    private class AddNode
    implements Callable<NodeMetadata> {
        private final String name;
        private final String tag;
        private final Template template;

        private AddNode(String name, String tag, Template template) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"tag");
            this.template = (Template)Preconditions.checkNotNull((Object)template, (Object)"template");
        }

        @Override
        public NodeMetadata call() throws Exception {
            NodeMetadata node = null;
            CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.debug(">> adding node location(%s) name(%s) image(%s) hardware(%s)", new Object[]{this.template.getLocation().getId(), this.name, this.template.getImage().getProviderId(), this.template.getHardware().getProviderId()});
            node = CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.addNodeWithTagStrategy.createNodeWithGroupEncodedIntoName(this.tag, this.name, this.template);
            CreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.debug("<< %s node(%s)", new Object[]{node.getState(), node.getId()});
            return node;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("tag", (Object)this.tag).add("template", (Object)this.template).toString();
        }
    }
}

