/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.stub.config;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.SocketOpen;

public class StubComputeServiceDependenciesModule
extends AbstractModule {
    protected static final ConcurrentMap<String, NodeMetadata> backing = new ConcurrentHashMap<String, NodeMetadata>();
    private static final AtomicInteger nodeIds = new AtomicInteger(0);
    static final ExecutorService service = Executors.newCachedThreadPool();

    protected void configure() {
    }

    @Provides
    @Singleton
    ConcurrentMap<String, NodeMetadata> provideNodes() {
        return backing;
    }

    @Provides
    @Named(value="NODE_ID")
    Integer provideNodeId() {
        return nodeIds.incrementAndGet();
    }

    @Singleton
    @Provides
    @Named(value="PUBLIC_IP_PREFIX")
    String publicIpPrefix() {
        return "144.175.1.";
    }

    @Singleton
    @Provides
    @Named(value="PRIVATE_IP_PREFIX")
    String privateIpPrefix() {
        return "10.1.1.";
    }

    @Singleton
    @Provides
    @Named(value="PASSWORD_PREFIX")
    String passwordPrefix() {
        return "password";
    }

    @Singleton
    @Provides
    SocketOpen socketOpen(StubSocketOpen in) {
        return in;
    }

    protected static void nodeWithState(NodeMetadata node, NodeState state) {
        backing.put(node.getId(), NodeMetadataBuilder.fromNodeMetadata(node).state(state).build());
    }

    public static void setState(final NodeMetadata node, final NodeState state, final long millis) {
        if (millis == 0L) {
            StubComputeServiceDependenciesModule.nodeWithState(node, state);
        } else {
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Throwables.propagate((Throwable)e);
                    }
                    StubComputeServiceDependenciesModule.nodeWithState(node, state);
                }
            });
        }
    }

    static Hardware stub(String type, int cores, int ram, float disk) {
        return new HardwareBuilder().ids(type).name(type).processors((List<Processor>)ImmutableList.of((Object)new Processor(cores, 1.0))).ram(ram).volumes((List<Volume>)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(disk), true, false))).build();
    }

    @Singleton
    public static class StubSocketOpen
    implements SocketOpen {
        private final ConcurrentMap<String, NodeMetadata> nodes;
        private final String publicIpPrefix;

        @Inject
        public StubSocketOpen(ConcurrentMap<String, NodeMetadata> nodes, @Named(value="PUBLIC_IP_PREFIX") String publicIpPrefix) {
            this.nodes = nodes;
            this.publicIpPrefix = publicIpPrefix;
        }

        public boolean apply(IPSocket input) {
            if (input.getAddress().indexOf(this.publicIpPrefix) == -1) {
                return false;
            }
            String id = input.getAddress().replace(this.publicIpPrefix, "");
            NodeMetadata node = (NodeMetadata)this.nodes.get(id);
            return node != null && node.getState() == NodeState.RUNNING;
        }
    }
}

