/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;

@Singleton
public class ComputeUtils {
    private final CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
    private final ExecutorService executor;

    @Inject
    public ComputeUtils(CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ExecutorService executor) {
        this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory = customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory;
        this.executor = executor;
    }

    public Map<?, Future<Void>> customizeNodesAndAddToGoodMapOrPutExceptionIntoBadMap(TemplateOptions options, Iterable<NodeMetadata> runningNodes, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        LinkedHashMap responses = Maps.newLinkedHashMap();
        for (NodeMetadata node : runningNodes) {
            responses.put(node, this.executor.submit(this.customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory.create(options, node, goodNodes, badNodes, customizationResponses)));
        }
        return responses;
    }
}

