/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.hpcloud.objectstorage.domain.CDNContainer;
import org.jclouds.hpcloud.objectstorage.functions.ParseCDNContainerFromHeaders;
import org.jclouds.hpcloud.objectstorage.functions.ParseCDNUriFromHeaders;
import org.jclouds.hpcloud.objectstorage.options.ListCDNContainerOptions;
import org.jclouds.hpcloud.services.HPExtensionCDN;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=HPExtensionCDN.class)
public interface CDNContainerAsyncApi {
    @Named(value="ListCDNEnabledContainers")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Path(value="/")
    @Beta
    public ListenableFuture<FluentIterable<CDNContainer>> list();

    @Named(value="ListCDNEnabledContainers")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Path(value="/")
    @Beta
    public ListenableFuture<FluentIterable<CDNContainer>> list(ListCDNContainerOptions var1);

    @Named(value="ListCDNEnabledContainerMetadata")
    @HEAD
    @ResponseParser(value=ParseCDNContainerFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    @Path(value="/{container}")
    @Beta
    public ListenableFuture<CDNContainer> get(@PathParam(value="container") String var1);

    @Named(value="CDNEnableContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCDNUriFromHeaders.class)
    @Beta
    public ListenableFuture<URI> enable(@PathParam(value="container") String var1, @HeaderParam(value="X-Ttl") long var2);

    @Named(value="CDNEnableContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCDNUriFromHeaders.class)
    @Beta
    public ListenableFuture<URI> enable(@PathParam(value="container") String var1);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @ResponseParser(value=ParseCDNUriFromHeaders.class)
    @Beta
    public ListenableFuture<URI> update(@PathParam(value="container") String var1, @HeaderParam(value="X-Ttl") long var2);

    @Named(value="DisableCDNEnabledContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-Cdn-Enabled"}, values={"False"})
    @Beta
    public ListenableFuture<Boolean> disable(@PathParam(value="container") String var1);
}

