/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import org.jclouds.hpcloud.objectstorage.domain.CDNContainer;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseCDNContainerFromHeaders
implements Function<HttpResponse, CDNContainer>,
InvocationContext<ParseCDNContainerFromHeaders> {
    private HttpRequest request;

    public CDNContainer apply(HttpResponse from) {
        String cdnUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Uri"), (Object)"X-Cdn-Uri");
        String cdnTTL = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Ttl"), (Object)"X-Ttl");
        String cdnEnabled = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Enabled"), (Object)"X-Cdn-Enabled");
        if (cdnUri == null) {
            return null;
        }
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)this.request.getEndpoint().getPath()));
        return CDNContainer.builder().name((String)parts.get(parts.size() - 1)).CDNEnabled(Boolean.parseBoolean(cdnEnabled)).ttl(Long.parseLong(cdnTTL)).CDNUri(URI.create(cdnUri)).build();
    }

    public ParseCDNContainerFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

