/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.Connection;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;

public class ConnectionLoggingHandler
extends LoggingHandlerSupport {
    public ConnectionLoggingHandler(Object target) {
        super(target);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object r = method.invoke(this.target, args);
            if ("unwrap".equals(method.getName())) {
                Class unwrapClass = (Class)args[0];
                if (r == this.target && unwrapClass.isInstance(proxy)) {
                    r = proxy;
                } else if (unwrapClass.isInterface() && Connection.class.isAssignableFrom(unwrapClass)) {
                    r = ProxyUtils.wrapByConnectionProxy(r);
                }
            } else {
                r = method.getName().equals("createStatement") ? ProxyUtils.wrapByStatementProxy(r) : (method.getName().equals("prepareCall") ? ProxyUtils.wrapByCallableStatementProxy(r, (String)args[0]) : (method.getName().equals("prepareStatement") ? ProxyUtils.wrapByPreparedStatementProxy(r, (String)args[0]) : ProxyUtils.wrap(r, new Object[0])));
            }
            return r;
        }
        catch (Throwable t) {
            LogUtils.handleException(t, Loggers.connectionLogger, LogUtils.createLogEntry(method, null, null, null));
            return null;
        }
    }
}

