/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.jdbcdslog.ConfigurationParameters;
import org.jdbcdslog.LogUtils;
import org.jdbcdslog.Loggers;
import org.jdbcdslog.LoggingHandlerSupport;
import org.jdbcdslog.ProxyUtils;

public class ResultSetLoggingHandler
extends LoggingHandlerSupport {
    private ResultSet targetResultSet = null;
    private int resultCount = 0;
    private long totalFetchTime = 0L;

    public ResultSetLoggingHandler(ResultSet target) {
        super(target);
        this.targetResultSet = target;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object r = null;
        long startTimeInNano = System.nanoTime();
        try {
            r = method.invoke((Object)this.targetResultSet, args);
        }
        catch (Throwable e) {
            LogUtils.handleException(e, Loggers.resultSetLogger, LogUtils.createLogEntry(method, null, null, null));
        }
        if ("unwrap".equals(method.getName())) {
            Class unwrapClass = (Class)args[0];
            if (r == this.target && unwrapClass.isInstance(proxy)) {
                r = proxy;
            } else if (unwrapClass.isInterface() && ResultSet.class.isAssignableFrom(unwrapClass)) {
                r = ProxyUtils.wrapByResultSetProxy(this.targetResultSet);
            }
        }
        if (Loggers.resultSetLogger.isInfoEnabled() && method.getName().equals("next")) {
            long elapsedTimeInNano = System.nanoTime() - startTimeInNano;
            this.totalFetchTime += elapsedTimeInNano;
            if (((Boolean)r).booleanValue()) {
                ++this.resultCount;
                if (Loggers.resultSetLogger.isDebugEnabled()) {
                    ResultSetMetaData md = this.targetResultSet.getMetaData();
                    StringBuilder sb = new StringBuilder(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
                    sb.append(" {");
                    for (int i = 1; i <= md.getColumnCount(); ++i) {
                        if (i > 1) {
                            sb.append(", ");
                        }
                        sb.append(ConfigurationParameters.rdbmsSpecifics.formatParameter(this.targetResultSet.getObject(i)));
                    }
                    sb.append("} Row Number: ").append(this.resultCount);
                    LogUtils.appendStackTrace(sb);
                    LogUtils.appendElapsedTime(sb, elapsedTimeInNano);
                    Loggers.resultSetLogger.debug(sb.toString());
                }
            } else {
                StringBuilder sb = new StringBuilder(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ").append(" Total Results: ").append(this.resultCount).append(".  Total Fetch Time: ").append(String.format("%.9f", (double)this.totalFetchTime / 1.0E9)).append(" s.");
                this.totalFetchTime = 0L;
                LogUtils.appendStackTrace(sb);
                LogUtils.appendElapsedTime(sb, elapsedTimeInNano);
                Loggers.resultSetLogger.info(sb.toString());
            }
        }
        return r;
    }
}

